/*
 * Decompiled with CFR 0.152.
 */
package ratpack.sse;

import io.netty.buffer.ByteBufAllocator;
import org.reactivestreams.Publisher;
import ratpack.func.Action;
import ratpack.handling.Context;
import ratpack.http.Response;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.render.Renderable;
import ratpack.sse.Event;
import ratpack.sse.internal.DefaultEvent;
import ratpack.sse.internal.ServerSentEventEncoder;
import ratpack.stream.Streams;

public class ServerSentEvents
implements Renderable {
    private final Publisher<? extends Event<?>> publisher;

    public static <T> ServerSentEvents serverSentEvents(Publisher<T> publisher, Action<? super Event<T>> action) {
        return new ServerSentEvents(Streams.map(publisher, item -> {
            Event event = action.with(new DefaultEvent<Object>(item));
            if (event.getId() == null && event.getEvent() == null && event.getData() == null) {
                throw new IllegalArgumentException("You must supply at least one of data, event, id");
            }
            return event;
        }));
    }

    private ServerSentEvents(Publisher<? extends Event<?>> publisher) {
        this.publisher = publisher;
    }

    public Publisher<? extends Event<?>> getPublisher() {
        return this.publisher;
    }

    @Override
    public void render(Context context) throws Exception {
        ByteBufAllocator bufferAllocator = context.get(ByteBufAllocator.class);
        Response response = context.getResponse();
        response.getHeaders().add(HttpHeaderConstants.CONTENT_TYPE, HttpHeaderConstants.TEXT_EVENT_STREAM_CHARSET_UTF_8);
        response.getHeaders().add(HttpHeaderConstants.TRANSFER_ENCODING, HttpHeaderConstants.CHUNKED);
        response.getHeaders().add(HttpHeaderConstants.CACHE_CONTROL, HttpHeaderConstants.NO_CACHE_FULL);
        response.getHeaders().add(HttpHeaderConstants.PRAGMA, HttpHeaderConstants.NO_CACHE);
        response.sendStream(Streams.map(this.publisher, i -> ServerSentEventEncoder.INSTANCE.encode((Event<?>)i, bufferAllocator)));
    }
}

