/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedInput;
import io.netty.handler.stream.ChunkedNioStream;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.FileInputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.api.Nullable;
import ratpack.exec.Blocking;
import ratpack.file.internal.ResponseTransmitter;
import ratpack.func.Action;
import ratpack.handling.RequestOutcome;
import ratpack.handling.internal.DefaultRequestOutcome;
import ratpack.handling.internal.DoubleTransmissionException;
import ratpack.http.Request;
import ratpack.http.internal.CustomHttpResponse;
import ratpack.http.internal.DefaultSentResponse;
import ratpack.http.internal.DefaultStatus;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.http.internal.NettyHeadersBackedHeaders;
import ratpack.server.internal.RequestBodyAccumulator;

public class DefaultResponseTransmitter
implements ResponseTransmitter {
    static final AttributeKey<DefaultResponseTransmitter> ATTRIBUTE_KEY = AttributeKey.valueOf((String)DefaultResponseTransmitter.class.getName());
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultResponseTransmitter.class);
    private static final Runnable NOOP_RUNNABLE = () -> {};
    private static final ChannelFutureListener CHANNEL_READ = f -> f.channel().read();
    private final AtomicBoolean transmitted;
    private final Channel channel;
    private final Request ratpackRequest;
    private final HttpHeaders responseHeaders;
    private final RequestBodyAccumulator requestBodyAccumulator;
    private final boolean isSsl;
    private List<Action<? super RequestOutcome>> outcomeListeners;
    private boolean isKeepAlive;
    private Instant stopTime;
    private Runnable onWritabilityChanged = NOOP_RUNNABLE;

    public DefaultResponseTransmitter(AtomicBoolean transmitted, Channel channel, HttpRequest nettyRequest, Request ratpackRequest, HttpHeaders responseHeaders, @Nullable RequestBodyAccumulator requestBodyAccumulator) {
        this.transmitted = transmitted;
        this.channel = channel;
        this.ratpackRequest = ratpackRequest;
        this.responseHeaders = responseHeaders;
        this.requestBodyAccumulator = requestBodyAccumulator;
        this.isKeepAlive = HttpUtil.isKeepAlive((HttpMessage)nettyRequest);
        this.isSsl = channel.pipeline().get(SslHandler.class) != null;
    }

    private ChannelFuture pre(HttpResponseStatus responseStatus) {
        if (this.transmitted.compareAndSet(false, true)) {
            this.stopTime = Instant.now();
            if (this.requestBodyAccumulator != null && !this.requestBodyAccumulator.isComplete()) {
                this.responseHeaders.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
                this.isKeepAlive = false;
            } else if (this.responseHeaders.contains((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.CLOSE, true)) {
                this.isKeepAlive = false;
            } else if (!this.isKeepAlive) {
                this.responseHeaders.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
            }
            CustomHttpResponse headersResponse = new CustomHttpResponse(responseStatus, this.responseHeaders);
            if (this.isKeepAlive && HttpUtil.getContentLength((HttpMessage)headersResponse, (int)-1) == -1 && !HttpUtil.isTransferEncodingChunked((HttpMessage)headersResponse)) {
                HttpUtil.setTransferEncodingChunked((HttpMessage)headersResponse, (boolean)true);
            }
            if (this.channel.isOpen()) {
                return this.channel.writeAndFlush((Object)headersResponse).addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
            }
            return null;
        }
        String msg = "attempt at double transmission for: " + this.ratpackRequest.getRawUri();
        LOGGER.warn(msg, (Throwable)new DoubleTransmissionException(msg));
        return null;
    }

    @Override
    public void transmit(HttpResponseStatus responseStatus, ByteBuf body) {
        this.transmit(responseStatus, new DefaultHttpContent(body), true);
    }

    private void transmit(HttpResponseStatus responseStatus, Object body, boolean sendLastHttpContent) {
        ChannelFuture channelFuture = this.pre(responseStatus);
        if (channelFuture == null) {
            ReferenceCountUtil.release((Object)body);
            return;
        }
        channelFuture.addListener(future -> {
            if (this.channel.isOpen()) {
                if (sendLastHttpContent) {
                    this.channel.write(body);
                    this.post(responseStatus);
                } else {
                    this.post(responseStatus, this.channel.writeAndFlush(body));
                }
            } else {
                ReferenceCountUtil.release((Object)body);
            }
        });
    }

    @Override
    public void transmit(HttpResponseStatus status, Path file) {
        boolean compress;
        String sizeString = this.responseHeaders.getAsString(HttpHeaderConstants.CONTENT_LENGTH);
        long size = sizeString == null ? 0L : Long.parseLong(sizeString);
        boolean bl = compress = !this.responseHeaders.contains(HttpHeaderConstants.CONTENT_ENCODING, HttpHeaderConstants.IDENTITY, true);
        if (!this.isSsl && !compress && file.getFileSystem().equals(FileSystems.getDefault())) {
            Blocking.get(() -> new FileInputStream(file.toFile()).getChannel()).then(fileChannel -> {
                DefaultFileRegion defaultFileRegion = new DefaultFileRegion(fileChannel, 0L, size);
                this.transmit(status, defaultFileRegion, true);
            });
        } else {
            Blocking.get(() -> Files.newByteChannel(file, new OpenOption[0])).then(fileChannel -> this.transmit(status, new HttpChunkedInput((ChunkedInput)new ChunkedNioStream((ReadableByteChannel)fileChannel)), false));
        }
    }

    @Override
    public Subscriber<ByteBuf> transmitter(final HttpResponseStatus responseStatus) {
        return new Subscriber<ByteBuf>(){
            private Subscription subscription;
            private final AtomicBoolean done = new AtomicBoolean();
            private final ChannelFutureListener cancelOnFailure = future -> {
                if (!this.done.get() && !future.isSuccess()) {
                    this.cancel();
                }
            };

            private void cancel() {
                if (this.done.compareAndSet(false, true)) {
                    this.subscription.cancel();
                    DefaultResponseTransmitter.this.post(responseStatus);
                }
            }

            public void onSubscribe(Subscription subscription) {
                if (subscription == null) {
                    throw new NullPointerException("'subscription' is null");
                }
                if (this.subscription != null) {
                    subscription.cancel();
                    return;
                }
                this.subscription = subscription;
                DefaultResponseTransmitter.this.onWritabilityChanged = () -> {
                    if (DefaultResponseTransmitter.this.channel.isWritable() && !this.done.get()) {
                        this.subscription.request(1L);
                    }
                };
                ChannelFuture channelFuture = DefaultResponseTransmitter.this.pre(responseStatus);
                if (channelFuture == null) {
                    subscription.cancel();
                    DefaultResponseTransmitter.this.notifyListeners(responseStatus, DefaultResponseTransmitter.this.channel.close());
                } else {
                    channelFuture.addListener((GenericFutureListener)this.cancelOnFailure);
                    if (DefaultResponseTransmitter.this.channel.isWritable()) {
                        this.subscription.request(1L);
                    }
                }
            }

            public void onNext(ByteBuf o) {
                o.touch();
                if (DefaultResponseTransmitter.this.channel.isOpen()) {
                    DefaultResponseTransmitter.this.channel.writeAndFlush((Object)new DefaultHttpContent(o)).addListener((GenericFutureListener)this.cancelOnFailure);
                    if (DefaultResponseTransmitter.this.channel.isWritable()) {
                        this.subscription.request(1L);
                    }
                } else {
                    o.release();
                    this.cancel();
                }
            }

            public void onError(Throwable t) {
                if (t == null) {
                    throw new NullPointerException("error is null");
                }
                LOGGER.warn("Exception thrown transmitting stream", t);
                if (this.done.compareAndSet(false, true)) {
                    DefaultResponseTransmitter.this.post(responseStatus);
                }
            }

            public void onComplete() {
                if (this.done.compareAndSet(false, true)) {
                    DefaultResponseTransmitter.this.channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT).addListener((GenericFutureListener)this.cancelOnFailure);
                    DefaultResponseTransmitter.this.post(responseStatus);
                }
            }
        };
    }

    private void post(HttpResponseStatus responseStatus) {
        this.post(responseStatus, this.channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT));
    }

    private void post(HttpResponseStatus responseStatus, ChannelFuture lastContentFuture) {
        if (this.channel.isOpen()) {
            if (this.isKeepAlive) {
                lastContentFuture.addListener((GenericFutureListener)CHANNEL_READ);
            } else {
                lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
            this.notifyListeners(responseStatus, lastContentFuture);
        } else {
            this.notifyListeners(responseStatus, this.channel.newSucceededFuture());
        }
    }

    private void notifyListeners(HttpResponseStatus responseStatus, ChannelFuture future) {
        if (this.outcomeListeners != null) {
            future.addListener(ignore -> {
                this.channel.attr(ATTRIBUTE_KEY).set(null);
                DefaultSentResponse sentResponse = new DefaultSentResponse(new NettyHeadersBackedHeaders(this.responseHeaders), new DefaultStatus(responseStatus));
                DefaultRequestOutcome requestOutcome = new DefaultRequestOutcome(this.ratpackRequest, sentResponse, this.stopTime);
                for (Action<? super RequestOutcome> outcomeListener : this.outcomeListeners) {
                    try {
                        outcomeListener.execute(requestOutcome);
                    }
                    catch (Exception e) {
                        LOGGER.warn("request outcome listener " + outcomeListener + " threw exception", (Throwable)e);
                    }
                }
            });
        }
    }

    public void writabilityChanged() {
        this.onWritabilityChanged.run();
    }

    @Override
    public void addOutcomeListener(Action<? super RequestOutcome> action) {
        if (this.outcomeListeners == null) {
            this.outcomeListeners = new ArrayList<Action<? super RequestOutcome>>(1);
        }
        this.outcomeListeners.add(action);
    }

    @Override
    public void forceCloseConnection() {
        this.responseHeaders.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
    }
}

