/*
 * Decompiled with CFR 0.152.
 */
package ratpack.health;

import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import ratpack.exec.Promise;
import ratpack.exec.Throttle;
import ratpack.exec.util.ParallelBatch;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.health.HealthCheck;
import ratpack.health.HealthCheckResults;
import ratpack.registry.Registry;
import ratpack.util.Types;

public class HealthCheckHandler
implements Handler {
    public static final String DEFAULT_NAME_TOKEN = "name";
    private static final TypeToken<HealthCheck> HEALTH_CHECK_TYPE_TOKEN = Types.token(HealthCheck.class);
    private final String name;
    private final Throttle throttle;

    public HealthCheckHandler() {
        this(DEFAULT_NAME_TOKEN, Throttle.unlimited());
    }

    public HealthCheckHandler(String pathTokenName) {
        this(pathTokenName, Throttle.unlimited());
    }

    public HealthCheckHandler(Throttle throttle) {
        this(DEFAULT_NAME_TOKEN, throttle);
    }

    protected HealthCheckHandler(String pathTokenName, Throttle throttle) {
        this.name = pathTokenName;
        this.throttle = throttle;
    }

    public Throttle getThrottle() {
        return this.throttle;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void handle(Context ctx) {
        ctx.getResponse().getHeaders().add("Cache-Control", "no-cache, no-store, must-revalidate").add("Pragma", "no-cache").add("Expires", 0);
        try {
            String checkName = (String)ctx.getPathTokens().get(this.name);
            if (checkName != null) {
                Optional<HealthCheck> first = ctx.first(HEALTH_CHECK_TYPE_TOKEN, healthCheck -> healthCheck.getName().equals(checkName) ? healthCheck : null);
                if (first.isPresent()) {
                    ctx.render(this.execute(ctx, Collections.singleton(first.get())));
                } else {
                    ctx.clientError(404);
                }
            } else {
                ctx.render(this.execute(ctx, ctx.getAll(HEALTH_CHECK_TYPE_TOKEN)));
            }
        }
        catch (Exception e) {
            ctx.error(e);
        }
    }

    private Promise<HealthCheckResults> execute(Registry registry, Iterable<? extends HealthCheck> healthChecks) {
        return Promise.wrap(() -> {
            Iterable resultPromises = Iterables.transform((Iterable)healthChecks, h -> Promise.wrap(() -> h.check(registry)).throttled(this.throttle).mapError(HealthCheck.Result::unhealthy).right(r -> h.getName()));
            ConcurrentHashMap results = new ConcurrentHashMap();
            return ParallelBatch.of(resultPromises).forEach((i, result) -> {
                HealthCheck.Result cfr_ignored_0 = (HealthCheck.Result)results.put(result.right, result.left);
            }).map(() -> new HealthCheckResults((ImmutableSortedMap<String, HealthCheck.Result>)ImmutableSortedMap.copyOf((Map)results)));
        });
    }
}

