/*
 * Decompiled with CFR 0.152.
 */
package ratpack.file.internal;

import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import ratpack.file.internal.FileRenderer;
import ratpack.func.Action;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.http.Request;
import ratpack.path.PathBinding;
import ratpack.path.internal.PathBindingStorage;
import ratpack.util.Exceptions;

public class FileHandler
implements Handler {
    private final ImmutableList<String> indexFiles;
    private final boolean cacheMetadata;

    public FileHandler(ImmutableList<String> indexFiles, boolean cacheMetadata) {
        this.indexFiles = indexFiles;
        this.cacheMetadata = cacheMetadata;
    }

    @Override
    public void handle(Context context) throws Exception {
        String path = ((PathBinding)((PathBindingStorage)context.getExecution().get(PathBindingStorage.TYPE)).peek()).getPastBinding();
        try {
            path = new URI(path).getPath();
        }
        catch (URISyntaxException e) {
            throw Exceptions.uncheck((Throwable)e);
        }
        Path asset = context.file(path);
        if (asset != null) {
            this.servePath(context, asset);
        } else {
            context.clientError(404);
        }
    }

    private void servePath(Context context, Path file) throws Exception {
        FileRenderer.readAttributes(file, this.cacheMetadata, (Action<? super BasicFileAttributes>)((Action)attributes -> {
            if (attributes == null) {
                context.next();
            } else if (attributes.isRegularFile()) {
                if (context.getRequest().getMethod().isGet()) {
                    FileRenderer.sendFile(context, file, attributes);
                } else {
                    context.clientError(405);
                }
            } else if (attributes.isDirectory()) {
                if (context.getRequest().getMethod().isGet()) {
                    this.maybeSendFile(context, file, 0);
                } else {
                    context.clientError(405);
                }
            } else {
                context.next();
            }
        }));
    }

    private void maybeSendFile(Context context, Path file, int i) throws Exception {
        if (i == this.indexFiles.size()) {
            context.next();
        } else {
            String name = (String)this.indexFiles.get(i);
            Path indexFile = file.resolve(name);
            FileRenderer.readAttributes(indexFile, this.cacheMetadata, (Action<? super BasicFileAttributes>)((Action)attributes -> {
                if (attributes != null && attributes.isRegularFile()) {
                    String path = context.getRequest().getPath();
                    if (path.endsWith("/") || path.isEmpty()) {
                        FileRenderer.sendFile(context, indexFile, attributes);
                    } else {
                        context.redirect(this.currentUriWithTrailingSlash(context));
                    }
                } else {
                    this.maybeSendFile(context, file, i + 1);
                }
            }));
        }
    }

    private String currentUriWithTrailingSlash(Context context) {
        Request request = context.getRequest();
        String redirectUri = "/" + request.getPath() + "/";
        String query = request.getQuery();
        if (!query.isEmpty()) {
            redirectUri = redirectUri + "?" + query;
        }
        return redirectUri;
    }
}

