/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.client.internal;

import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpResponse;

class NoContentLengthOnNoBodyHttpObjectAggregator
extends HttpObjectAggregator {
    NoContentLengthOnNoBodyHttpObjectAggregator(int maxContentLength) {
        super(maxContentLength);
    }

    protected void finishAggregation(FullHttpMessage aggregated) throws Exception {
        if (aggregated.content().readableBytes() == 0 && aggregated instanceof HttpResponse) {
            HttpResponse httpResponse = (HttpResponse)aggregated;
            int status = httpResponse.status().code();
            if (status == 204 || status >= 100 && status < 200) {
                httpResponse.headers().remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                return;
            }
            if (status == 304) {
                return;
            }
        }
        super.finishAggregation(aggregated);
    }
}

