/*
 * Decompiled with CFR 0.152.
 */
package ratpack.config.internal.module;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import javax.net.ssl.KeyManagerFactory;
import ratpack.ssl.internal.SslContexts;
import ratpack.util.Exceptions;

public class NettySslContextDeserializer
extends JsonDeserializer<SslContext> {
    public SslContext deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ObjectNode node = (ObjectNode)jp.readValueAsTree();
        try {
            KeyManagerFactory keyManagerFactory;
            String keyStoreFile = node.path("keystoreFile").asText();
            String keyStorePassword = node.path("keystorePassword").asText();
            String trustStoreFile = node.path("truststoreFile").asText();
            String trustStorePassword = node.path("truststorePassword").asText();
            if (keyStoreFile.isEmpty()) {
                throw new IllegalStateException("keystoreFile must be set if any ssl properties are set");
            }
            if (keyStorePassword.isEmpty()) {
                throw new IllegalStateException("keystorePassword must be set if any ssl properties are set");
            }
            if (!trustStoreFile.isEmpty() && trustStorePassword.isEmpty()) {
                throw new IllegalStateException("truststorePassword must be specified when truststoreFile is specified");
            }
            try (InputStream is = Files.newInputStream(Paths.get(keyStoreFile, new String[0]), new OpenOption[0]);){
                keyManagerFactory = SslContexts.keyManagerFactory(is, keyStorePassword.toCharArray());
            }
            SslContextBuilder builder = SslContextBuilder.forServer((KeyManagerFactory)keyManagerFactory);
            if (!trustStoreFile.isEmpty()) {
                try (InputStream is = Files.newInputStream(Paths.get(trustStoreFile, new String[0]), new OpenOption[0]);){
                    builder.trustManager(SslContexts.trustManagerFactory(is, trustStorePassword.toCharArray()));
                }
            }
            return builder.build();
        }
        catch (GeneralSecurityException ex) {
            throw Exceptions.uncheck((Throwable)ex);
        }
    }
}

