/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.client;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.ssl.SslContext;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import javax.net.ssl.SSLContext;
import ratpack.func.Action;
import ratpack.func.Factory;
import ratpack.func.Function;
import ratpack.http.HttpMethod;
import ratpack.http.MutableHeaders;
import ratpack.http.client.ReceivedResponse;

public interface RequestSpec {
    public static final int DEFAULT_MAX_REDIRECTS = 10;

    public RequestSpec redirects(int var1);

    public RequestSpec onRedirect(Function<? super ReceivedResponse, Action<? super RequestSpec>> var1);

    @Deprecated
    public RequestSpec sslContext(SSLContext var1);

    @Deprecated
    default public RequestSpec sslContext(Factory<SSLContext> factory) throws Exception {
        return this.sslContext((SSLContext)factory.create());
    }

    public RequestSpec sslContext(SslContext var1);

    public MutableHeaders getHeaders();

    public RequestSpec maxContentLength(int var1);

    public RequestSpec responseMaxChunkSize(int var1);

    public RequestSpec headers(Action<? super MutableHeaders> var1) throws Exception;

    default public RequestSpec method(String method) {
        return this.method(HttpMethod.of(method));
    }

    public RequestSpec method(HttpMethod var1);

    default public RequestSpec get() {
        return this.method(HttpMethod.GET);
    }

    default public RequestSpec post() {
        return this.method(HttpMethod.POST);
    }

    default public RequestSpec put() {
        return this.method(HttpMethod.PUT);
    }

    default public RequestSpec delete() {
        return this.method(HttpMethod.DELETE);
    }

    default public RequestSpec patch() {
        return this.method(HttpMethod.PATCH);
    }

    default public RequestSpec options() {
        return this.method(HttpMethod.OPTIONS);
    }

    default public RequestSpec head() {
        return this.method(HttpMethod.HEAD);
    }

    public RequestSpec decompressResponse(boolean var1);

    public URI getUri();

    @Deprecated
    default public URI getUrl() {
        return this.getUri();
    }

    @Deprecated
    default public RequestSpec connectTimeoutSeconds(int seconds) {
        return this.connectTimeout(Duration.of(seconds, ChronoUnit.SECONDS));
    }

    public RequestSpec connectTimeout(Duration var1);

    @Deprecated
    default public RequestSpec readTimeoutSeconds(int seconds) {
        return this.readTimeout(Duration.of(seconds, ChronoUnit.SECONDS));
    }

    public RequestSpec readTimeout(Duration var1);

    public Body getBody();

    public RequestSpec body(Action<? super Body> var1) throws Exception;

    default public RequestSpec basicAuth(String username, String password) {
        byte[] bytes = (username + ":" + password).getBytes(StandardCharsets.ISO_8859_1);
        byte[] encodedBytes = Base64.getEncoder().encode(bytes);
        this.getHeaders().set((CharSequence)HttpHeaderNames.AUTHORIZATION, "Basic " + new String(encodedBytes, StandardCharsets.ISO_8859_1));
        return this;
    }

    public static interface Body {
        public Body type(CharSequence var1);

        public Body stream(Action<? super OutputStream> var1) throws Exception;

        public Body buffer(ByteBuf var1);

        public Body bytes(byte[] var1);

        public Body text(CharSequence var1);

        public Body text(CharSequence var1, Charset var2);
    }
}

