/*
 * Decompiled with CFR 0.152.
 */
package ratpack.handling.internal;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ratpack.func.Action;
import ratpack.handling.ByContentSpec;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.http.internal.MimeParse;
import ratpack.registry.Registry;

public class ContentNegotiationHandler
implements Handler {
    private final Map<String, Handler> handlers = new LinkedHashMap<String, Handler>();
    private final List<String> reverseKeys;
    private final Handler noMatchHandler;
    private final Handler unspecifiedHandler;

    public ContentNegotiationHandler(Registry registry, Action<? super ByContentSpec> action) throws Exception {
        DefaultByContentSpec spec = new DefaultByContentSpec(registry, this.handlers);
        action.execute((Object)spec);
        this.noMatchHandler = spec.noMatchHandler;
        this.unspecifiedHandler = spec.unspecifiedHandler;
        this.reverseKeys = new ArrayList<String>(this.handlers.keySet());
        Collections.reverse(this.reverseKeys);
    }

    @Override
    public void handle(Context context) throws Exception {
        if (this.handlers.isEmpty()) {
            this.noMatchHandler.handle(context);
            return;
        }
        String acceptHeader = context.getRequest().getHeaders().get((CharSequence)HttpHeaderNames.ACCEPT);
        if (Strings.isNullOrEmpty((String)acceptHeader)) {
            this.unspecifiedHandler.handle(context);
        } else {
            String winner = MimeParse.bestMatch(this.reverseKeys, acceptHeader);
            if (Strings.isNullOrEmpty((String)winner)) {
                this.noMatchHandler.handle(context);
            } else {
                context.getResponse().contentType(winner);
                this.handlers.get(winner).handle(context);
            }
        }
    }

    public static class DefaultByContentSpec
    implements ByContentSpec {
        private static final String TYPE_HTML = "text/html";
        private static final String TYPE_XML = "application/xml";
        private final Map<String, Handler> handlers;
        private final Registry registry;
        private Handler noMatchHandler = ctx -> ctx.clientError(406);
        private Handler unspecifiedHandler;

        public DefaultByContentSpec(Registry registry, Map<String, Handler> handlers) {
            this.registry = registry;
            this.handlers = handlers;
            this.unspecifiedHandler = ctx -> {
                Map.Entry first = (Map.Entry)Iterables.getFirst(handlers.entrySet(), null);
                if (first == null) {
                    this.noMatchHandler.handle(ctx);
                } else {
                    ctx.getResponse().contentType((CharSequence)first.getKey());
                    ((Handler)first.getValue()).handle(ctx);
                }
            };
        }

        @Override
        public ByContentSpec type(String mimeType, Handler handler) {
            return this.type((CharSequence)mimeType, handler);
        }

        @Override
        public ByContentSpec type(CharSequence mimeType, Handler handler) {
            if (mimeType == null) {
                throw new IllegalArgumentException("mimeType cannot be null");
            }
            String trimmed = mimeType.toString().trim();
            if (trimmed.isEmpty()) {
                throw new IllegalArgumentException("mimeType cannot be a blank string");
            }
            if (trimmed.contains("*")) {
                throw new IllegalArgumentException("mimeType cannot include wildcards");
            }
            this.handlers.put(trimmed, handler);
            return this;
        }

        @Override
        public ByContentSpec plainText(Handler handler) {
            return this.type((CharSequence)HttpHeaderValues.TEXT_PLAIN, handler);
        }

        @Override
        public ByContentSpec html(Handler handler) {
            return this.type(TYPE_HTML, handler);
        }

        @Override
        public ByContentSpec json(Handler handler) {
            return this.type((CharSequence)HttpHeaderValues.APPLICATION_JSON, handler);
        }

        @Override
        public ByContentSpec xml(Handler handler) {
            return this.type(TYPE_XML, handler);
        }

        @Override
        public ByContentSpec noMatch(Handler handler) {
            this.noMatchHandler = handler;
            return this;
        }

        @Override
        public ByContentSpec noMatch(String mimeType) {
            this.noMatchHandler = this.handleWithMimeTypeBlock(mimeType);
            return this;
        }

        @Override
        public ByContentSpec unspecified(Handler handler) {
            this.unspecifiedHandler = handler;
            return this;
        }

        @Override
        public ByContentSpec unspecified(String mimeType) {
            this.unspecifiedHandler = this.handleWithMimeTypeBlock(mimeType);
            return this;
        }

        private Handler handleWithMimeTypeBlock(String mimeType) {
            return ctx -> {
                Handler handler = this.handlers.get(mimeType);
                if (handler == null) {
                    ctx.error(new IllegalStateException("No handler defined for mimeType " + mimeType));
                } else {
                    ctx.getResponse().contentType(mimeType);
                    handler.handle(ctx);
                }
            };
        }

        @Override
        public ByContentSpec type(String mimeType, Class<? extends Handler> handlerType) {
            return this.type(mimeType, (Handler)this.registry.get(handlerType));
        }

        @Override
        public ByContentSpec type(CharSequence mimeType, Class<? extends Handler> handlerType) {
            return this.type(mimeType, (Handler)this.registry.get(handlerType));
        }

        @Override
        public ByContentSpec plainText(Class<? extends Handler> handlerType) {
            return this.plainText((Handler)this.registry.get(handlerType));
        }

        @Override
        public ByContentSpec html(Class<? extends Handler> handlerType) {
            return this.html((Handler)this.registry.get(handlerType));
        }

        @Override
        public ByContentSpec json(Class<? extends Handler> handlerType) {
            return this.json((Handler)this.registry.get(handlerType));
        }

        @Override
        public ByContentSpec xml(Class<? extends Handler> handlerType) {
            return this.xml((Handler)this.registry.get(handlerType));
        }

        @Override
        public ByContentSpec noMatch(Class<? extends Handler> handlerType) {
            return this.noMatch((Handler)this.registry.get(handlerType));
        }

        @Override
        public ByContentSpec unspecified(Class<? extends Handler> handlerType) {
            return this.unspecified((Handler)this.registry.get(handlerType));
        }
    }
}

