/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.client.internal;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.pool.ChannelHealthChecker;
import io.netty.channel.pool.ChannelPool;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.pool.FixedChannelPool;
import io.netty.channel.pool.SimpleChannelPool;
import java.net.URI;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import ratpack.exec.ExecController;
import ratpack.exec.Execution;
import ratpack.exec.Operation;
import ratpack.exec.Promise;
import ratpack.exec.internal.ExecControllerInternal;
import ratpack.func.Action;
import ratpack.http.client.HttpClient;
import ratpack.http.client.HttpClientSpec;
import ratpack.http.client.HttpResponse;
import ratpack.http.client.ReceivedResponse;
import ratpack.http.client.RequestSpec;
import ratpack.http.client.StreamedResponse;
import ratpack.http.client.internal.ChannelPoolStats;
import ratpack.http.client.internal.ContentAggregatingRequestAction;
import ratpack.http.client.internal.ContentStreamingRequestAction;
import ratpack.http.client.internal.HttpChannelKey;
import ratpack.http.client.internal.HttpChannelPoolMap;
import ratpack.http.client.internal.HttpClientInternal;
import ratpack.http.client.internal.HttpClientStats;
import ratpack.http.client.internal.InstrumentedChannelPoolHandler;
import ratpack.http.client.internal.InstrumentedFixedChannelPoolHandler;
import ratpack.http.client.internal.InstrumentedSimpleChannelPoolHandler;
import ratpack.http.client.internal.NoopFixedChannelPoolHandler;
import ratpack.http.client.internal.NoopSimpleChannelPoolHandler;
import ratpack.util.internal.TransportDetector;

public class DefaultHttpClient
implements HttpClientInternal {
    private static final ChannelHealthChecker ALWAYS_UNHEALTHY = channel -> channel.eventLoop().newSucceededFuture((Object)Boolean.FALSE);
    private final Map<String, ChannelPoolStats> hostStats = new ConcurrentHashMap<String, ChannelPoolStats>();
    private final HttpChannelPoolMap channelPoolMap = new HttpChannelPoolMap(){

        protected ChannelPool newPool(HttpChannelKey key) {
            Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().remoteAddress(key.host, key.port).group((EventLoopGroup)key.execution.getEventLoop())).channel(TransportDetector.getSocketChannelImpl())).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)key.connectTimeout.toMillis()))).option(ChannelOption.ALLOCATOR, (Object)DefaultHttpClient.this.spec.byteBufAllocator)).option(ChannelOption.AUTO_READ, (Object)false)).option(ChannelOption.SO_KEEPALIVE, (Object)DefaultHttpClient.this.isPooling());
            if (DefaultHttpClient.this.isPooling()) {
                InstrumentedChannelPoolHandler channelPoolHandler = DefaultHttpClient.this.getPoolingHandler(key);
                DefaultHttpClient.this.hostStats.put(key.host, channelPoolHandler);
                FixedChannelPool channelPool = new FixedChannelPool(bootstrap, (ChannelPoolHandler)channelPoolHandler, DefaultHttpClient.this.getPoolSize(), DefaultHttpClient.this.getPoolQueueSize());
                ((ExecControllerInternal)key.execution.getController()).onClose(() -> this.lambda$newPool$0(key, (ChannelPool)channelPool));
                return channelPool;
            }
            InstrumentedChannelPoolHandler channelPoolHandler = DefaultHttpClient.this.getSimpleHandler(key);
            DefaultHttpClient.this.hostStats.put(key.host, channelPoolHandler);
            return new SimpleChannelPool(bootstrap, (ChannelPoolHandler)channelPoolHandler, ALWAYS_UNHEALTHY);
        }

        private /* synthetic */ void lambda$newPool$0(HttpChannelKey key, ChannelPool channelPool) throws Exception {
            this.remove(key);
            channelPool.close();
        }
    };
    private final Spec spec;

    private DefaultHttpClient(Spec spec) {
        this.spec = spec;
    }

    private InstrumentedChannelPoolHandler getPoolingHandler(HttpChannelKey key) {
        if (this.spec.enableMetricsCollection) {
            return new InstrumentedFixedChannelPoolHandler(key, this.getPoolSize());
        }
        return new NoopFixedChannelPoolHandler(key);
    }

    private InstrumentedChannelPoolHandler getSimpleHandler(HttpChannelKey key) {
        if (this.spec.enableMetricsCollection) {
            return new InstrumentedSimpleChannelPoolHandler(key);
        }
        return new NoopSimpleChannelPoolHandler(key);
    }

    @Override
    public int getPoolSize() {
        return this.spec.poolSize;
    }

    @Override
    public int getPoolQueueSize() {
        return this.spec.poolQueueSize;
    }

    private boolean isPooling() {
        return this.getPoolSize() > 0;
    }

    @Override
    public HttpChannelPoolMap getChannelPoolMap() {
        return this.channelPoolMap;
    }

    @Override
    public Action<? super RequestSpec> getRequestInterceptor() {
        return this.spec.requestInterceptor;
    }

    @Override
    public Action<? super HttpResponse> getResponseInterceptor() {
        return this.spec.responseInterceptor;
    }

    @Override
    public ByteBufAllocator getByteBufAllocator() {
        return this.spec.byteBufAllocator;
    }

    @Override
    public int getMaxContentLength() {
        return this.spec.maxContentLength;
    }

    @Override
    public int getMaxResponseChunkSize() {
        return this.spec.responseMaxChunkSize;
    }

    @Override
    public Duration getReadTimeout() {
        return this.spec.readTimeout;
    }

    @Override
    public Duration getConnectTimeout() {
        return this.spec.connectTimeout;
    }

    @Override
    public void close() {
        this.channelPoolMap.close();
    }

    @Override
    public HttpClient copyWith(Action<? super HttpClientSpec> action) throws Exception {
        return DefaultHttpClient.of(new Spec(this.spec), action);
    }

    public static HttpClient of(Action<? super HttpClientSpec> action) throws Exception {
        Spec spec = new Spec();
        return DefaultHttpClient.of(spec, action);
    }

    private static HttpClient of(Spec spec, Action<? super HttpClientSpec> action) throws Exception {
        action.execute((Object)spec);
        return new DefaultHttpClient(spec);
    }

    @Override
    public Promise<ReceivedResponse> get(URI uri, Action<? super RequestSpec> action) {
        return this.request(uri, action);
    }

    @Override
    public Promise<ReceivedResponse> post(URI uri, Action<? super RequestSpec> action) {
        return this.request(uri, (Action<? super RequestSpec>)action.prepend(RequestSpec::post));
    }

    @Override
    public Promise<ReceivedResponse> request(URI uri, Action<? super RequestSpec> requestConfigurer) {
        return this.intercept(Promise.async(downstream -> new ContentAggregatingRequestAction(uri, this, 0, Execution.current(), (Action<? super RequestSpec>)requestConfigurer.append(this.spec.requestInterceptor)).connect(downstream)), (Action<? super HttpResponse>)this.spec.responseInterceptor, (Action<? super Throwable>)this.spec.errorInterceptor);
    }

    @Override
    public Promise<StreamedResponse> requestStream(URI uri, Action<? super RequestSpec> requestConfigurer) {
        return this.intercept(Promise.async(downstream -> new ContentStreamingRequestAction(uri, this, 0, Execution.current(), (Action<? super RequestSpec>)requestConfigurer.append(this.spec.requestInterceptor)).connect(downstream)), (Action<? super HttpResponse>)this.spec.responseInterceptor, (Action<? super Throwable>)this.spec.errorInterceptor);
    }

    private <T extends HttpResponse> Promise<T> intercept(Promise<T> promise, Action<? super HttpResponse> action, Action<? super Throwable> errorAction) {
        return promise.wiretap(r -> {
            if (r.isError()) {
                ExecController.require().fork().eventLoop(Execution.current().getEventLoop()).start(e -> errorAction.execute((Object)r.getThrowable()));
            }
        }).next(r -> ExecController.require().fork().eventLoop(Execution.current().getEventLoop()).start(e -> action.execute(r)));
    }

    public HttpClientStats getHttpClientStats() {
        return new HttpClientStats(this.hostStats.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ChannelPoolStats)e.getValue()).getHostStats())));
    }

    private static class Spec
    implements HttpClientSpec {
        private ByteBufAllocator byteBufAllocator = PooledByteBufAllocator.DEFAULT;
        private int poolSize;
        private int poolQueueSize = Integer.MAX_VALUE;
        private int maxContentLength = 0x100000;
        private int responseMaxChunkSize = 8192;
        private Duration readTimeout = Duration.ofSeconds(30L);
        private Duration connectTimeout = Duration.ofSeconds(30L);
        private Action<? super RequestSpec> requestInterceptor = Action.noop();
        private Action<? super HttpResponse> responseInterceptor = Action.noop();
        private Action<? super Throwable> errorInterceptor = Action.noop();
        private boolean enableMetricsCollection;

        private Spec() {
        }

        private Spec(Spec spec) {
            this.byteBufAllocator = spec.byteBufAllocator;
            this.poolSize = spec.poolSize;
            this.poolQueueSize = spec.poolQueueSize;
            this.maxContentLength = spec.maxContentLength;
            this.responseMaxChunkSize = spec.responseMaxChunkSize;
            this.readTimeout = spec.readTimeout;
            this.connectTimeout = spec.connectTimeout;
            this.requestInterceptor = spec.requestInterceptor;
            this.responseInterceptor = spec.responseInterceptor;
            this.enableMetricsCollection = spec.enableMetricsCollection;
        }

        @Override
        public HttpClientSpec poolSize(int poolSize) {
            this.poolSize = poolSize;
            return this;
        }

        @Override
        public HttpClientSpec poolQueueSize(int poolQueueSize) {
            this.poolQueueSize = poolQueueSize;
            return this;
        }

        @Override
        public HttpClientSpec byteBufAllocator(ByteBufAllocator byteBufAllocator) {
            this.byteBufAllocator = byteBufAllocator;
            return this;
        }

        @Override
        public HttpClientSpec maxContentLength(int maxContentLength) {
            this.maxContentLength = maxContentLength;
            return this;
        }

        @Override
        public HttpClientSpec responseMaxChunkSize(int numBytes) {
            this.responseMaxChunkSize = numBytes;
            return this;
        }

        @Override
        public HttpClientSpec readTimeout(Duration readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        @Override
        public HttpClientSpec connectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        @Override
        public HttpClientSpec requestIntercept(Action<? super RequestSpec> interceptor) {
            this.requestInterceptor = this.requestInterceptor.append(interceptor);
            return this;
        }

        @Override
        public HttpClientSpec responseIntercept(Action<? super HttpResponse> interceptor) {
            this.responseInterceptor = this.responseInterceptor.append(interceptor);
            return this;
        }

        @Override
        public HttpClientSpec responseIntercept(Operation operation) {
            this.responseInterceptor = this.responseInterceptor.append(response -> operation.then());
            return this;
        }

        @Override
        public HttpClientSpec errorIntercept(Action<? super Throwable> interceptor) {
            this.errorInterceptor = this.errorInterceptor.append(interceptor);
            return this;
        }

        @Override
        public HttpClientSpec enableMetricsCollection(boolean enableMetricsCollection) {
            this.enableMetricsCollection = enableMetricsCollection;
            return this;
        }
    }
}

