/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.internal;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import java.nio.charset.Charset;
import ratpack.http.MediaType;

public class DefaultMediaType
implements MediaType {
    public static final String CHARSET_KEY = "charset";
    private final String type;
    private final ImmutableListMultimap<String, String> params;
    private final String string;
    private static final int CACHE_SIZE = 1024;
    private static final LoadingCache<String, MediaType> CACHE = Caffeine.newBuilder().maximumSize(1024L).build(DefaultMediaType::new);

    public static MediaType get(String contentType) {
        return (MediaType)CACHE.get((Object)(contentType == null ? "" : contentType));
    }

    private DefaultMediaType(String value) {
        value = value.trim();
        if (value.length() == 0) {
            this.type = null;
            this.params = ImmutableListMultimap.of();
            this.string = "";
        } else {
            com.google.common.net.MediaType mediaType;
            try {
                mediaType = com.google.common.net.MediaType.parse((String)value);
            }
            catch (IllegalArgumentException e) {
                this.type = value;
                this.string = value;
                this.params = ImmutableListMultimap.of();
                return;
            }
            if (mediaType != null && mediaType.type() != null) {
                this.type = mediaType.subtype() != null ? mediaType.type() + "/" + mediaType.subtype() : mediaType.type();
                this.params = mediaType.parameters();
                this.string = mediaType.toString();
            } else {
                this.type = null;
                this.params = ImmutableListMultimap.of();
                this.string = "";
            }
        }
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public ImmutableListMultimap<String, String> getParams() {
        return this.params;
    }

    @Override
    public String getCharset() {
        return this.getCharset(null);
    }

    @Override
    public String getCharset(String defaultCharset) {
        ImmutableList charsetValues = this.params.get((Object)CHARSET_KEY);
        switch (charsetValues.size()) {
            case 0: {
                return defaultCharset;
            }
            case 1: {
                return Charset.forName((String)charsetValues.get(0)).toString();
            }
        }
        throw new IllegalStateException("Multiple charset values defined: " + charsetValues);
    }

    @Override
    public boolean isText() {
        return this.getType() != null && this.getType().startsWith("text/");
    }

    @Override
    public boolean isJson() {
        return this.getType() != null && (this.getType().equals("application/json") || this.getType().endsWith("+json"));
    }

    @Override
    public boolean isForm() {
        return this.getType() != null && this.getType().equals("application/x-www-form-urlencoded");
    }

    @Override
    public boolean isHtml() {
        return this.getType() != null && this.getType().equals("text/html");
    }

    @Override
    public boolean isEmpty() {
        return this.getType() == null;
    }

    public String toString() {
        return this.string;
    }
}

