/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedInput;
import io.netty.handler.stream.ChunkedNioStream;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.api.Nullable;
import ratpack.exec.Blocking;
import ratpack.exec.Execution;
import ratpack.exec.Promise;
import ratpack.file.internal.ResponseTransmitter;
import ratpack.func.Action;
import ratpack.handling.RequestOutcome;
import ratpack.handling.internal.DefaultRequestOutcome;
import ratpack.handling.internal.DoubleTransmissionException;
import ratpack.http.Request;
import ratpack.http.RequestBodyTooLargeException;
import ratpack.http.internal.ConnectionIdleTimeout;
import ratpack.http.internal.CustomHttpResponse;
import ratpack.http.internal.DefaultSentResponse;
import ratpack.http.internal.DefaultStatus;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.http.internal.NettyHeadersBackedHeaders;
import ratpack.server.internal.RequestBody;

public class DefaultResponseTransmitter
implements ResponseTransmitter {
    static final AttributeKey<DefaultResponseTransmitter> ATTRIBUTE_KEY = AttributeKey.valueOf((String)DefaultResponseTransmitter.class.getName());
    private static final Logger LOGGER = LoggerFactory.getLogger(ResponseTransmitter.class);
    private static final Runnable NOOP_RUNNABLE = () -> {};
    private final AtomicBoolean transmitted;
    private final Channel channel;
    private final Clock clock;
    private final Request ratpackRequest;
    private final HttpHeaders responseHeaders;
    private final RequestBody requestBody;
    private final boolean isSsl;
    private List<Action<? super RequestOutcome>> outcomeListeners;
    private boolean isKeepAlive;
    private Instant stopTime;
    private Runnable onWritabilityChanged = NOOP_RUNNABLE;
    private static final Set<OpenOption> OPEN_OPTIONS = Collections.singleton(StandardOpenOption.READ);

    public DefaultResponseTransmitter(AtomicBoolean transmitted, Channel channel, Clock clock, HttpRequest nettyRequest, Request ratpackRequest, HttpHeaders responseHeaders, @Nullable RequestBody requestBody) {
        this.transmitted = transmitted;
        this.channel = channel;
        this.clock = clock;
        this.ratpackRequest = ratpackRequest;
        this.responseHeaders = responseHeaders;
        this.requestBody = requestBody;
        this.isKeepAlive = HttpUtil.isKeepAlive((HttpMessage)nettyRequest);
        this.isSsl = channel.pipeline().get(SslHandler.class) != null;
    }

    private void drainRequestBody(Consumer<Throwable> next) {
        if (this.requestBody == null || !this.requestBody.isUnread()) {
            next.accept(null);
        } else if (Execution.isActive()) {
            Promise.async(down -> this.requestBody.drain(e -> {
                if (e == null) {
                    down.success(null);
                } else {
                    down.error(e);
                }
            })).onError(next::accept).then(n -> next.accept(null));
        } else {
            this.requestBody.drain(next);
        }
    }

    private ChannelFuture pre(HttpResponseStatus responseStatus, boolean flushHeaders) {
        if (this.transmitted.compareAndSet(false, true)) {
            this.stopTime = this.clock.instant();
            try {
                if (this.responseHeaders.contains((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.CLOSE, true)) {
                    this.isKeepAlive = false;
                } else if (!this.isKeepAlive) {
                    this.forceCloseConnection();
                }
                CustomHttpResponse headersResponse = new CustomHttpResponse(responseStatus, this.responseHeaders);
                if (this.mustHaveBody(responseStatus) && this.isKeepAlive && HttpUtil.getContentLength((HttpMessage)headersResponse, (int)-1) == -1 && !HttpUtil.isTransferEncodingChunked((HttpMessage)headersResponse)) {
                    HttpUtil.setTransferEncodingChunked((HttpMessage)headersResponse, (boolean)true);
                }
                if (this.channel.isOpen()) {
                    if (flushHeaders) {
                        return this.channel.writeAndFlush((Object)headersResponse);
                    }
                    return this.channel.write((Object)headersResponse);
                }
                return null;
            }
            catch (Exception e) {
                LOGGER.warn("Error finalizing response", (Throwable)e);
                return null;
            }
        }
        String msg = "attempt at double transmission for: " + this.ratpackRequest.getRawUri();
        LOGGER.warn(msg, (Throwable)new DoubleTransmissionException(msg));
        return null;
    }

    private boolean mustHaveBody(HttpResponseStatus responseStatus) {
        int code = responseStatus.code();
        return (code < 100 || code >= 200) && code != 204 && code != 304;
    }

    @Override
    public void transmit(HttpResponseStatus responseStatus, ByteBuf body) {
        if (body.readableBytes() == 0) {
            body.release();
            this.transmit(responseStatus, LastHttpContent.EMPTY_LAST_CONTENT, false);
        } else {
            this.transmit(responseStatus, new DefaultLastHttpContent(body), false);
        }
    }

    private void transmit(HttpResponseStatus responseStatus, Object body, boolean sendLastHttpContent) {
        ChannelFuture channelFuture = this.pre(responseStatus, false);
        if (channelFuture == null) {
            ReferenceCountUtil.release((Object)body);
            this.isKeepAlive = false;
            this.post(responseStatus);
            return;
        }
        if (sendLastHttpContent) {
            this.channel.write(body);
            this.post(responseStatus);
        } else {
            this.post(responseStatus, this.channel.writeAndFlush(body));
        }
    }

    @Override
    public void transmit(HttpResponseStatus status, Path file) {
        boolean compress;
        String sizeString = this.responseHeaders.getAsString(HttpHeaderConstants.CONTENT_LENGTH);
        long size = sizeString == null ? 0L : Long.parseLong(sizeString);
        boolean bl = compress = !this.responseHeaders.contains(HttpHeaderConstants.CONTENT_ENCODING, HttpHeaderConstants.IDENTITY, true);
        if (!this.isSsl && !compress && file.getFileSystem().equals(FileSystems.getDefault())) {
            FileChannel fileChannel2;
            try {
                fileChannel2 = FileChannel.open(file, OPEN_OPTIONS, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            DefaultFileRegion defaultFileRegion = new DefaultFileRegion(fileChannel2, 0L, size);
            this.transmit(status, defaultFileRegion, true);
        } else {
            Blocking.get(() -> Files.newByteChannel(file, new OpenOption[0])).then(fileChannel -> this.transmit(status, new HttpChunkedInput((ChunkedInput)new ChunkedNioStream((ReadableByteChannel)fileChannel)), false));
        }
    }

    @Override
    public Subscriber<ByteBuf> transmitter(final HttpResponseStatus responseStatus) {
        return new Subscriber<ByteBuf>(){
            private Subscription subscription;
            private final AtomicBoolean done = new AtomicBoolean();
            private final ChannelFutureListener cancelOnFailure = future -> {
                if (!future.isSuccess()) {
                    this.cancel();
                }
            };
            private final GenericFutureListener<Future<? super Void>> cancelOnCloseListener = c -> this.cancel();

            private void cancel() {
                DefaultResponseTransmitter.this.channel.closeFuture().removeListener(this.cancelOnCloseListener);
                if (this.done.compareAndSet(false, true)) {
                    this.subscription.cancel();
                    DefaultResponseTransmitter.this.post(responseStatus);
                }
            }

            public void onSubscribe(Subscription subscription) {
                if (subscription == null) {
                    throw new NullPointerException("'subscription' is null");
                }
                if (this.subscription != null) {
                    subscription.cancel();
                    return;
                }
                this.subscription = subscription;
                ChannelFuture channelFuture = DefaultResponseTransmitter.this.pre(responseStatus, true);
                if (channelFuture == null) {
                    subscription.cancel();
                    DefaultResponseTransmitter.this.isKeepAlive = false;
                    DefaultResponseTransmitter.this.notifyListeners(responseStatus);
                } else {
                    channelFuture.addListener(f -> {
                        if (f.isSuccess() && DefaultResponseTransmitter.this.channel.isOpen()) {
                            DefaultResponseTransmitter.this.channel.closeFuture().addListener(this.cancelOnCloseListener);
                            if (DefaultResponseTransmitter.this.channel.isWritable()) {
                                this.subscription.request(1L);
                            }
                            DefaultResponseTransmitter.this.onWritabilityChanged = () -> {
                                if (DefaultResponseTransmitter.this.channel.isWritable() && !this.done.get()) {
                                    this.subscription.request(1L);
                                }
                            };
                        } else {
                            this.cancel();
                        }
                    });
                }
            }

            public void onNext(ByteBuf o) {
                o.touch();
                if (DefaultResponseTransmitter.this.channel.isOpen()) {
                    DefaultResponseTransmitter.this.channel.writeAndFlush((Object)new DefaultHttpContent(o)).addListener((GenericFutureListener)this.cancelOnFailure);
                    if (DefaultResponseTransmitter.this.channel.isWritable()) {
                        this.subscription.request(1L);
                    }
                } else {
                    o.release();
                    this.cancel();
                }
            }

            public void onError(Throwable t) {
                if (t == null) {
                    throw new NullPointerException("error is null");
                }
                LOGGER.warn("Exception thrown transmitting stream", t);
                if (this.done.compareAndSet(false, true)) {
                    DefaultResponseTransmitter.this.channel.closeFuture().removeListener(this.cancelOnCloseListener);
                    DefaultResponseTransmitter.this.post(responseStatus);
                }
            }

            public void onComplete() {
                if (this.done.compareAndSet(false, true)) {
                    DefaultResponseTransmitter.this.channel.closeFuture().removeListener(this.cancelOnCloseListener);
                    DefaultResponseTransmitter.this.post(responseStatus);
                }
            }
        };
    }

    private void post(HttpResponseStatus responseStatus) {
        this.post(responseStatus, this.channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT));
    }

    private void post(HttpResponseStatus responseStatus, ChannelFuture lastContentFuture) {
        lastContentFuture.addListener(v -> this.drainRequestBody(e -> {
            if (LOGGER.isWarnEnabled()) {
                if (e instanceof RequestBodyTooLargeException) {
                    LOGGER.warn("Unread request body was too large to drain, will close connection (maxContentLength: {})", (Object)((RequestBodyTooLargeException)e).getMaxContentLength());
                } else if (e != null) {
                    LOGGER.warn("An error occurred draining the unread request body. The connection will be closed", e);
                }
            }
            if (this.channel.isOpen()) {
                if (this.isKeepAlive && e == null) {
                    lastContentFuture.channel().read();
                    ConnectionIdleTimeout.of(this.channel).reset();
                } else {
                    lastContentFuture.channel().close();
                }
            }
            this.notifyListeners(responseStatus);
        }));
    }

    private void notifyListeners(HttpResponseStatus responseStatus) {
        if (this.outcomeListeners != null) {
            this.channel.attr(ATTRIBUTE_KEY).set(null);
            DefaultSentResponse sentResponse = new DefaultSentResponse(new NettyHeadersBackedHeaders(this.responseHeaders), new DefaultStatus(responseStatus));
            DefaultRequestOutcome requestOutcome = new DefaultRequestOutcome(this.ratpackRequest, sentResponse, this.stopTime);
            for (Action<? super RequestOutcome> outcomeListener : this.outcomeListeners) {
                try {
                    outcomeListener.execute((Object)requestOutcome);
                }
                catch (Exception e) {
                    LOGGER.warn("request outcome listener " + outcomeListener + " threw exception", (Throwable)e);
                }
            }
        }
    }

    public void writabilityChanged() {
        this.onWritabilityChanged.run();
    }

    @Override
    public void addOutcomeListener(Action<? super RequestOutcome> action) {
        if (this.outcomeListeners == null) {
            this.outcomeListeners = new ArrayList<Action<? super RequestOutcome>>(1);
        }
        this.outcomeListeners.add(action);
    }

    @Override
    public void forceCloseConnection() {
        this.responseHeaders.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
    }
}

