/*
 * Decompiled with CFR 0.152.
 */
package ratpack.sse.internal;

import ratpack.func.Function;
import ratpack.sse.Event;

public class DefaultEvent<T>
implements Event<T> {
    private final T item;
    private String id;
    private String event;
    private String data;
    private String comment;

    public DefaultEvent(T item) {
        this.item = item;
    }

    public DefaultEvent() {
        this(null);
    }

    @Override
    public T getItem() {
        return this.item;
    }

    @Override
    public Event<T> id(Function<? super T, String> id) throws Exception {
        this.id((String)id.apply(this.item));
        return this;
    }

    @Override
    public Event<T> id(String id) {
        if (id.contains("\n")) {
            throw new IllegalArgumentException("id must not contain \\n - '" + id + "'");
        }
        this.id = id;
        return this;
    }

    @Override
    public Event<T> event(Function<? super T, String> id) throws Exception {
        this.event((String)id.apply(this.item));
        return this;
    }

    @Override
    public Event<T> event(String event) {
        if (event.contains("\n")) {
            throw new IllegalArgumentException("event must not contain \\n - '" + event + "'");
        }
        this.event = event;
        return this;
    }

    @Override
    public Event<T> data(Function<? super T, String> id) throws Exception {
        this.data((String)id.apply(this.item));
        return this;
    }

    @Override
    public Event<T> data(String data) {
        this.data = data;
        return this;
    }

    @Override
    public Event<T> comment(String comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getEvent() {
        return this.event;
    }

    @Override
    public String getData() {
        return this.data;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public String toString() {
        return "Event{id='" + this.id + '\'' + ", event='" + this.event + '\'' + ", data='" + this.data + '\'' + '}';
    }
}

