/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.client.internal;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.pool.AbstractChannelPoolHandler;
import io.netty.handler.timeout.IdleStateHandler;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import ratpack.http.client.internal.HttpChannelKey;
import ratpack.http.client.internal.IdleTimeoutHandler;
import ratpack.http.client.internal.IdlingConnectionHandler;
import ratpack.http.client.internal.InstrumentedChannelPoolHandler;

public class NoopFixedChannelPoolHandler
extends AbstractChannelPoolHandler
implements InstrumentedChannelPoolHandler {
    private final String host;
    private final Duration idleTimeout;

    public NoopFixedChannelPoolHandler(HttpChannelKey channelKey, Duration idleTimeout) {
        this.host = channelKey.host;
        this.idleTimeout = idleTimeout;
    }

    public void channelCreated(Channel ch) throws Exception {
        if (this.idleTimeout.toNanos() > 0L) {
            ch.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(this.idleTimeout.toNanos(), this.idleTimeout.toNanos(), 0L, TimeUnit.NANOSECONDS)});
            ch.pipeline().addLast(new ChannelHandler[]{IdleTimeoutHandler.INSTANCE});
        }
    }

    public void channelReleased(Channel ch) throws Exception {
        if (ch.isOpen()) {
            ch.config().setAutoRead(true);
            ch.pipeline().addLast(new ChannelHandler[]{IdlingConnectionHandler.INSTANCE});
        }
    }

    public void channelAcquired(Channel ch) throws Exception {
        if (ch.pipeline().context((ChannelHandler)IdlingConnectionHandler.INSTANCE) != null) {
            ch.pipeline().remove((ChannelHandler)IdlingConnectionHandler.INSTANCE);
        }
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getActiveConnectionCount() {
        return 0;
    }

    @Override
    public int getIdleConnectionCount() {
        return 0;
    }
}

