/*
 * Decompiled with CFR 0.152.
 */
package ratpack.error.internal;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.error.ClientErrorHandler;
import ratpack.error.ServerErrorHandler;
import ratpack.error.internal.ErrorHandler;
import ratpack.handling.Context;

public class DefaultProductionErrorHandler
implements ErrorHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultProductionErrorHandler.class);

    @Override
    public void error(Context context, int statusCode) throws Exception {
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn(this.getMsg(ClientErrorHandler.class, "client error", context));
        }
        context.getResponse().status(statusCode).send();
    }

    @Override
    public void error(Context context, Throwable throwable) throws Exception {
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn(this.getMsg(ServerErrorHandler.class, "server error", context) + "\n", throwable);
        }
        context.getResponse().status(500).send();
    }

    private String getMsg(Class<?> handlerClass, String type, Context context) {
        return "Default production error handler used to render " + type + ", please add a " + handlerClass.getName() + " instance to your application (method: " + context.getRequest().getMethod() + ", uri: " + context.getRequest().getRawUri() + ")";
    }
}

