/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import ratpack.func.Block;
import ratpack.server.RatpackServer;

public abstract class ServerCapturer {
    private static final ThreadLocal<RatpackServer> SERVER_HOLDER = new ThreadLocal();

    private ServerCapturer() {
    }

    public static RatpackServer capture(Block bootstrap) throws Exception {
        try {
            bootstrap.execute();
            RatpackServer ratpackServer = SERVER_HOLDER.get();
            return ratpackServer;
        }
        finally {
            SERVER_HOLDER.remove();
        }
    }

    public static void capture(RatpackServer server) throws Exception {
        SERVER_HOLDER.set(server);
    }
}

