/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.netty.util.CharsetUtil;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import ratpack.api.Nullable;
import ratpack.exec.Operation;
import ratpack.file.internal.ResponseTransmitter;
import ratpack.func.Action;
import ratpack.http.Headers;
import ratpack.http.MutableHeaders;
import ratpack.http.Response;
import ratpack.http.Status;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.util.Exceptions;
import ratpack.util.MultiValueMap;

public class DefaultResponse
implements Response {
    private Status status = Status.OK;
    private final MutableHeaders headers;
    private final ByteBufAllocator byteBufAllocator;
    private final ResponseTransmitter responseTransmitter;
    private boolean contentTypeSet;
    private Set<Cookie> cookies;
    private List<Action<? super Response>> responseFinalizers;

    public DefaultResponse(MutableHeaders headers, ByteBufAllocator byteBufAllocator, ResponseTransmitter responseTransmitter) {
        this.byteBufAllocator = byteBufAllocator;
        this.responseTransmitter = responseTransmitter;
        this.headers = new MutableHeadersWrapper(headers);
        this.responseFinalizers = Lists.newArrayList();
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public Response status(Status status) {
        this.status = status;
        return this;
    }

    @Override
    public Response noCompress() {
        this.headers.set((CharSequence)HttpHeaderNames.CONTENT_ENCODING, HttpHeaderValues.IDENTITY);
        return this;
    }

    @Override
    public MutableHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public void send() {
        this.commit(Unpooled.EMPTY_BUFFER);
    }

    @Override
    public Response contentTypeIfNotSet(Supplier<CharSequence> contentType) {
        if (!this.contentTypeSet) {
            this.contentType(contentType.get());
        }
        return this;
    }

    @Override
    public Response contentType(CharSequence contentType) {
        this.headers.set(HttpHeaderConstants.CONTENT_TYPE, contentType);
        return this;
    }

    @Override
    public Response contentTypeIfNotSet(CharSequence contentType) {
        if (!this.contentTypeSet) {
            this.contentType(contentType);
        }
        return this;
    }

    @Override
    public void send(String text) {
        ByteBuf byteBuf = ByteBufUtil.encodeString((ByteBufAllocator)this.byteBufAllocator, (CharBuffer)CharBuffer.wrap(text), (Charset)CharsetUtil.UTF_8);
        this.contentTypeIfNotSet(HttpHeaderConstants.PLAIN_TEXT_UTF8).send(byteBuf);
    }

    @Override
    public void send(CharSequence contentType, String body) {
        this.contentType(contentType);
        this.send(body);
    }

    @Override
    public void send(byte[] bytes) {
        this.contentTypeIfNotSet(HttpHeaderConstants.OCTET_STREAM);
        this.commit(Unpooled.wrappedBuffer((byte[])bytes));
    }

    @Override
    public void send(CharSequence contentType, byte[] bytes) {
        this.contentType(contentType).send(bytes);
    }

    @Override
    public void send(CharSequence contentType, ByteBuf buffer) {
        this.contentType(contentType);
        this.send(buffer);
    }

    @Override
    public void send(ByteBuf buffer) {
        this.contentTypeIfNotSet(HttpHeaderConstants.OCTET_STREAM);
        this.commit(buffer);
    }

    @Override
    public void sendFile(Path file) {
        this.finalizeResponse(() -> {
            this.setCookieHeader();
            this.responseTransmitter.transmit(this.status.getNettyStatus(), file);
        }, t -> {
            throw t;
        });
    }

    @Override
    public void sendStream(Publisher<? extends ByteBuf> stream) {
        this.finalizeResponse(() -> {
            this.setCookieHeader();
            stream.subscribe(this.responseTransmitter.transmitter(this.status.getNettyStatus()));
        }, t -> {
            throw t;
        });
    }

    @Override
    public Response beforeSend(Action<? super Response> responseFinalizer) {
        this.responseFinalizers.add(responseFinalizer);
        return this;
    }

    @Override
    public Set<Cookie> getCookies() {
        if (this.cookies == null) {
            this.cookies = new OverwritingSet<Cookie>();
        }
        return this.cookies;
    }

    @Override
    public Cookie cookie(String name, String value) {
        DefaultCookie cookie = new DefaultCookie(name, value);
        this.getCookies().add((Cookie)cookie);
        return cookie;
    }

    @Override
    public Cookie expireCookie(String name) {
        Cookie cookie = this.cookie(name, "");
        cookie.setMaxAge(0L);
        return cookie;
    }

    private void setCookieHeader() {
        if (this.cookies != null && !this.cookies.isEmpty()) {
            for (Cookie cookie : this.cookies) {
                this.headers.add(HttpHeaderConstants.SET_COOKIE, ServerCookieEncoder.STRICT.encode(cookie));
            }
        }
    }

    private void commit(ByteBuf buffer) {
        int readableBytes = buffer.readableBytes();
        if (readableBytes > 0 || !this.mustNotHaveBody()) {
            this.headers.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, readableBytes);
        }
        this.finalizeResponse(() -> {
            this.setCookieHeader();
            this.responseTransmitter.transmit(this.status.getNettyStatus(), buffer);
        }, t -> {
            buffer.release();
            throw t;
        });
    }

    private boolean mustNotHaveBody() {
        int code = this.status.getCode();
        return code >= 100 && code < 200 || code == 204 || code == 304;
    }

    private void finalizeResponse(Runnable then, Consumer<? super RuntimeException> onError) {
        ImmutableList finalizersCopy = ImmutableList.copyOf(this.responseFinalizers);
        this.responseFinalizers.clear();
        if (finalizersCopy.isEmpty()) {
            try {
                then.run();
            }
            catch (Exception t) {
                onError.accept(Exceptions.uncheck((Throwable)t));
            }
        } else {
            this.finalizeResponse(finalizersCopy.iterator(), then, onError);
        }
    }

    private void finalizeResponse(Iterator<Action<? super Response>> finalizers, Runnable then, Consumer<? super RuntimeException> onError) {
        if (finalizers.hasNext()) {
            ((Operation)finalizers.next().curry((Object)this).map(Operation::of)).onError(t -> onError.accept(Exceptions.uncheck((Throwable)t))).then(() -> this.finalizeResponse(finalizers, then, onError));
        } else {
            this.finalizeResponse(then, onError);
        }
    }

    private static class OverwritingSet<T>
    extends HashSet<T> {
        private OverwritingSet() {
        }

        @Override
        public boolean add(T item) {
            if (!super.add(item)) {
                super.remove(item);
                return super.add(item);
            }
            return true;
        }
    }

    class MutableHeadersWrapper
    implements MutableHeaders {
        private final MutableHeaders wrapped;

        MutableHeadersWrapper(MutableHeaders wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public MutableHeaders add(CharSequence name, Object value) {
            if (!DefaultResponse.this.contentTypeSet && (name == HttpHeaderConstants.CONTENT_TYPE || name.toString().equalsIgnoreCase(HttpHeaderConstants.CONTENT_TYPE.toString()))) {
                DefaultResponse.this.contentTypeSet = true;
            }
            this.wrapped.add(name, value);
            return this;
        }

        @Override
        public MutableHeaders set(CharSequence name, Object value) {
            if (!DefaultResponse.this.contentTypeSet && (name == HttpHeaderConstants.CONTENT_TYPE || name.toString().equalsIgnoreCase(HttpHeaderConstants.CONTENT_TYPE.toString()))) {
                DefaultResponse.this.contentTypeSet = true;
            }
            this.wrapped.set(name, value);
            return this;
        }

        @Override
        public MutableHeaders setDate(CharSequence name, Date value) {
            this.wrapped.set(name, value);
            return this;
        }

        @Override
        public MutableHeaders set(CharSequence name, Iterable<?> values) {
            if (!DefaultResponse.this.contentTypeSet && (name == HttpHeaderConstants.CONTENT_TYPE || name.toString().equalsIgnoreCase(HttpHeaderConstants.CONTENT_TYPE.toString()))) {
                DefaultResponse.this.contentTypeSet = true;
            }
            this.wrapped.set(name, values);
            return this;
        }

        @Override
        public MutableHeaders remove(CharSequence name) {
            if (name == HttpHeaderConstants.CONTENT_TYPE || name.toString().equalsIgnoreCase(HttpHeaderConstants.CONTENT_TYPE.toString())) {
                DefaultResponse.this.contentTypeSet = false;
            }
            this.wrapped.remove(name);
            return this;
        }

        @Override
        public MutableHeaders clear() {
            DefaultResponse.this.contentTypeSet = false;
            this.wrapped.clear();
            return this;
        }

        @Override
        public MutableHeaders copy(Headers headers) {
            this.wrapped.copy(headers);
            if (headers.contains(HttpHeaderConstants.CONTENT_TYPE)) {
                DefaultResponse.this.contentTypeSet = true;
            }
            return this;
        }

        @Override
        public MultiValueMap<String, String> asMultiValueMap() {
            return this.wrapped.asMultiValueMap();
        }

        @Override
        @Nullable
        public String get(CharSequence name) {
            return this.wrapped.get(name);
        }

        @Override
        @Nullable
        public String get(String name) {
            return this.wrapped.get(name);
        }

        @Override
        @Nullable
        public Date getDate(CharSequence name) {
            return this.wrapped.getDate(name);
        }

        @Override
        @Nullable
        public Date getDate(String name) {
            return this.wrapped.getDate(name);
        }

        @Override
        public List<String> getAll(CharSequence name) {
            return this.wrapped.getAll(name);
        }

        @Override
        public List<String> getAll(String name) {
            return this.wrapped.getAll(name);
        }

        @Override
        public boolean contains(CharSequence name) {
            return this.wrapped.contains(name);
        }

        @Override
        public boolean contains(String name) {
            return this.wrapped.contains(name);
        }

        @Override
        public Set<String> getNames() {
            return this.wrapped.getNames();
        }

        @Override
        public HttpHeaders getNettyHeaders() {
            return this.wrapped.getNettyHeaders();
        }
    }
}

