/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.file.checksummer.internal;

import java.io.InputStream;
import java.security.MessageDigest;
import ratpack.func.Function;

public class MD5Checksummer
implements Function<InputStream, String> {
    private static final int BUFFER_SIZE = 8192;

    public String apply(InputStream is) throws Exception {
        byte[] buffer = new byte[8192];
        MessageDigest md = MessageDigest.getInstance("MD5");
        int read = is.read(buffer, 0, 8192);
        while (read != -1) {
            md.update(buffer, 0, read);
            read = is.read(buffer, 0, 8192);
        }
        byte[] digest = md.digest();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < digest.length; ++i) {
            sb.append(Integer.toString((digest[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }
}

