/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.handling;

import com.google.common.reflect.TypeToken;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.Optional;
import ratpack.config.FileSystemBinding;
import ratpack.core.handling.ByContentSpec;
import ratpack.core.handling.ByMethodSpec;
import ratpack.core.handling.Handler;
import ratpack.core.handling.RequestOutcome;
import ratpack.core.handling.direct.DirectChannelAccess;
import ratpack.core.http.Request;
import ratpack.core.http.Response;
import ratpack.core.http.TypedData;
import ratpack.core.parse.Parse;
import ratpack.core.path.PathBinding;
import ratpack.core.path.PathTokens;
import ratpack.core.render.NoSuchRendererException;
import ratpack.core.server.ServerConfig;
import ratpack.exec.Execution;
import ratpack.exec.Promise;
import ratpack.exec.api.NonBlocking;
import ratpack.exec.registry.NotInRegistryException;
import ratpack.exec.registry.Registry;
import ratpack.func.Action;
import ratpack.func.Types;

public interface Context
extends Registry {
    public static final TypeToken<Context> TYPE = Types.token(Context.class);

    public Context getContext();

    public Execution getExecution();

    public ServerConfig getServerConfig();

    public Request getRequest();

    public Response getResponse();

    @NonBlocking
    public void next();

    @NonBlocking
    public void next(Registry var1);

    @NonBlocking
    public void insert(Handler ... var1);

    @NonBlocking
    public void insert(Registry var1, Handler ... var2);

    @NonBlocking
    public void byMethod(Action<? super ByMethodSpec> var1) throws Exception;

    public void byContent(Action<? super ByContentSpec> var1) throws Exception;

    @NonBlocking
    public void error(Throwable var1);

    @NonBlocking
    public void clientError(int var1) throws NotInRegistryException;

    @NonBlocking
    public void render(Object var1) throws NoSuchRendererException;

    default public Optional<String> header(CharSequence name) {
        return Optional.ofNullable(this.getRequest().getHeaders().get(name));
    }

    default public Context header(CharSequence name, Object ... values) {
        this.getResponse().getHeaders().set(name, Arrays.asList(values));
        return this;
    }

    public void redirect(Object var1);

    public void redirect(int var1, Object var2);

    @NonBlocking
    default public void lastModified(Date lastModified, Runnable serve) {
        this.lastModified(lastModified.toInstant(), serve);
    }

    @NonBlocking
    public void lastModified(Instant var1, Runnable var2);

    public <T> Promise<T> parse(Class<T> var1);

    public <T> Promise<T> parse(TypeToken<T> var1);

    public <T, O> Promise<T> parse(Class<T> var1, O var2);

    public <T, O> Promise<T> parse(TypeToken<T> var1, O var2);

    public <T, O> Promise<T> parse(Parse<T, O> var1);

    public <T, O> T parse(TypedData var1, Parse<T, O> var2) throws Exception;

    public DirectChannelAccess getDirectChannelAccess();

    public PathBinding getPathBinding();

    default public PathTokens getPathTokens() throws NotInRegistryException {
        return this.getPathBinding().getTokens();
    }

    default public PathTokens getAllPathTokens() throws NotInRegistryException {
        return this.getPathBinding().getAllTokens();
    }

    public void onClose(Action<? super RequestOutcome> var1);

    public Path file(String var1) throws NotInRegistryException;

    default public FileSystemBinding getFileSystemBinding() {
        return (FileSystemBinding)this.get(FileSystemBinding.TYPE);
    }

    default public void notFound() {
        this.clientError(404);
    }
}

