/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.handling.internal;

import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import ratpack.core.handling.ByMethodSpec;
import ratpack.core.handling.Context;
import ratpack.core.handling.Handler;
import ratpack.core.handling.Handlers;
import ratpack.core.http.HttpMethod;
import ratpack.core.http.internal.HttpHeaderConstants;
import ratpack.exec.registry.Registry;
import ratpack.func.Action;
import ratpack.func.Block;

public class MultiMethodHandler
implements Handler {
    private static final Joiner JOINER = Joiner.on((String)",");
    private static final Handler NO_METHOD_HANDLER = Handlers.clientError(HttpResponseStatus.METHOD_NOT_ALLOWED.code());
    private final Map<HttpMethod, Handler> handlers = Maps.newHashMap();

    public MultiMethodHandler(Registry registry, Action<? super ByMethodSpec> action) throws Exception {
        action.execute((Object)new DefaultByMethodSpec(registry, this.handlers));
    }

    @Override
    public void handle(Context context) throws Exception {
        HttpMethod method = context.getRequest().getMethod();
        if (method.isOptions() && !this.handlers.containsKey(HttpMethod.OPTIONS)) {
            ArrayList parts = new ArrayList(Collections2.transform(this.handlers.keySet(), HttpMethod::getName));
            Collections.sort(parts);
            String methods = JOINER.join(parts);
            context.getResponse().getHeaders().add(HttpHeaderConstants.ALLOW, methods);
            context.getResponse().status(200).send();
        } else {
            Handler getHandler;
            Handler handler = this.handlers.get(method);
            if (handler != null) {
                context.insert(handler);
                return;
            }
            if (method.isHead() && (getHandler = this.handlers.get(HttpMethod.GET)) != null) {
                context.insert(getHandler);
                return;
            }
            NO_METHOD_HANDLER.handle(context);
        }
    }

    public static class DefaultByMethodSpec
    implements ByMethodSpec {
        private final Map<HttpMethod, Handler> handlers;
        private final Registry registry;

        public DefaultByMethodSpec(Registry registry, Map<HttpMethod, Handler> handlers) {
            this.handlers = handlers;
            this.registry = registry;
        }

        @Override
        public ByMethodSpec get(Block block) {
            return this.get(this.handler(block));
        }

        @Override
        public ByMethodSpec get(Class<? extends Handler> clazz) {
            return this.get(this.handler(clazz));
        }

        @Override
        public ByMethodSpec get(Handler handler) {
            return this.add(HttpMethod.GET, handler);
        }

        @Override
        public ByMethodSpec post(Block block) {
            return this.post(this.handler(block));
        }

        @Override
        public ByMethodSpec post(Class<? extends Handler> clazz) {
            return this.post(this.handler(clazz));
        }

        @Override
        public ByMethodSpec post(Handler handler) {
            return this.add(HttpMethod.POST, handler);
        }

        @Override
        public ByMethodSpec put(Block block) {
            return this.put(this.handler(block));
        }

        @Override
        public ByMethodSpec put(Class<? extends Handler> clazz) {
            return this.put(this.handler(clazz));
        }

        @Override
        public ByMethodSpec put(Handler handler) {
            return this.add(HttpMethod.PUT, handler);
        }

        @Override
        public ByMethodSpec patch(Block block) {
            return this.patch(this.handler(block));
        }

        @Override
        public ByMethodSpec patch(Class<? extends Handler> clazz) {
            return this.patch(this.handler(clazz));
        }

        @Override
        public ByMethodSpec patch(Handler handler) {
            return this.add(HttpMethod.PATCH, handler);
        }

        @Override
        public ByMethodSpec options(Block block) {
            return this.options(this.handler(block));
        }

        @Override
        public ByMethodSpec options(Class<? extends Handler> clazz) {
            return this.options(this.handler(clazz));
        }

        @Override
        public ByMethodSpec options(Handler handler) {
            return this.add(HttpMethod.OPTIONS, handler);
        }

        @Override
        public ByMethodSpec delete(Block block) {
            return this.delete(this.handler(block));
        }

        @Override
        public ByMethodSpec delete(Class<? extends Handler> clazz) {
            return this.delete(this.handler(clazz));
        }

        @Override
        public ByMethodSpec delete(Handler handler) {
            return this.add(HttpMethod.DELETE, handler);
        }

        @Override
        public ByMethodSpec named(String methodName, Block block) {
            this.named(methodName, this.handler(block));
            return this;
        }

        @Override
        public ByMethodSpec named(String methodName, Class<? extends Handler> clazz) {
            return this.named(methodName, this.handler(clazz));
        }

        @Override
        public ByMethodSpec named(String methodName, Handler handler) {
            return this.add(HttpMethod.of(methodName), handler);
        }

        private ByMethodSpec add(HttpMethod method, Handler handler) {
            this.handlers.put(method, handler);
            return this;
        }

        private Handler handler(Class<? extends Handler> clazz) {
            return (Handler)this.registry.get(clazz);
        }

        private Handler handler(Block block) {
            return ctx -> block.execute();
        }
    }
}

