/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.http.client.internal;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.util.concurrent.Future;
import java.net.URI;
import ratpack.core.bytebuf.ByteBufRef;
import ratpack.core.http.client.ReceivedResponse;
import ratpack.core.http.client.RequestSpec;
import ratpack.core.http.client.internal.HttpClientInternal;
import ratpack.core.http.client.internal.NoContentLengthOnNoBodyHttpObjectAggregator;
import ratpack.core.http.client.internal.RequestActionSupport;
import ratpack.exec.Downstream;
import ratpack.exec.Execution;
import ratpack.exec.Upstream;
import ratpack.func.Action;

class ContentAggregatingRequestAction
extends RequestActionSupport<ReceivedResponse> {
    private static final String AGGREGATOR_HANDLER_NAME = "aggregator";
    private static final String RESPONSE_HANDLER_NAME = "response";

    ContentAggregatingRequestAction(URI uri, HttpClientInternal client, int redirectCount, boolean expectContinue, Execution execution, Action<? super RequestSpec> requestConfigurer) throws Exception {
        super(uri, client, redirectCount, expectContinue, execution, requestConfigurer);
    }

    @Override
    protected Future<Void> doDispose(ChannelPipeline channelPipeline, boolean forceClose) {
        channelPipeline.remove(AGGREGATOR_HANDLER_NAME);
        channelPipeline.remove(RESPONSE_HANDLER_NAME);
        return super.doDispose(channelPipeline, forceClose);
    }

    @Override
    protected void addResponseHandlers(ChannelPipeline p, final Downstream<? super ReceivedResponse> downstream) {
        p.addLast(AGGREGATOR_HANDLER_NAME, (ChannelHandler)new NoContentLengthOnNoBodyHttpObjectAggregator(this.requestConfig.maxContentLength));
        p.addLast(RESPONSE_HANDLER_NAME, (ChannelHandler)new SimpleChannelInboundHandler<FullHttpResponse>(false){

            protected void channelRead0(ChannelHandlerContext ctx, FullHttpResponse response) throws Exception {
                response.touch();
                ContentAggregatingRequestAction.this.dispose(ctx.pipeline(), (HttpResponse)response).addListener(future -> {
                    if (future.isSuccess()) {
                        ByteBufRef content = new ByteBufRef(response.content());
                        ContentAggregatingRequestAction.this.execution.onComplete(() -> {
                            if (content.refCnt() > 0) {
                                content.release();
                            }
                        });
                        downstream.success((Object)ContentAggregatingRequestAction.this.toReceivedResponse((HttpResponse)response, content));
                    } else {
                        downstream.error(future.cause());
                    }
                });
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                Throwable decorated = ContentAggregatingRequestAction.this.decorateException(cause);
                ContentAggregatingRequestAction.this.forceDispose(ctx.pipeline()).addListener(future -> {
                    if (!future.isSuccess()) {
                        decorated.addSuppressed(future.cause());
                    }
                    downstream.error(decorated);
                });
            }
        });
    }

    @Override
    protected Upstream<ReceivedResponse> onRedirect(URI locationUrl, int redirectCount, boolean expectContinue, Action<? super RequestSpec> redirectRequestConfig) throws Exception {
        return new ContentAggregatingRequestAction(locationUrl, this.client, redirectCount, expectContinue, this.execution, redirectRequestConfig);
    }
}

