/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.http.client.internal;

import io.netty.channel.Channel;
import java.time.Duration;
import java.util.concurrent.atomic.LongAdder;
import ratpack.core.http.client.internal.HttpChannelKey;
import ratpack.core.http.client.internal.NoopFixedChannelPoolHandler;
import ratpack.core.http.client.internal.ProxyInternal;

public class InstrumentedFixedChannelPoolHandler
extends NoopFixedChannelPoolHandler {
    private final LongAdder activeConnectionCount = new LongAdder();
    private final int maxConnectionCount;

    public InstrumentedFixedChannelPoolHandler(HttpChannelKey channelKey, int poolSize, Duration idleTimeout, ProxyInternal proxy) {
        super(channelKey, idleTimeout, proxy);
        this.maxConnectionCount = poolSize;
    }

    @Override
    public void channelReleased(Channel ch) throws Exception {
        super.channelReleased(ch);
        this.activeConnectionCount.decrement();
    }

    @Override
    public void channelAcquired(Channel ch) throws Exception {
        super.channelAcquired(ch);
        this.activeConnectionCount.increment();
    }

    @Override
    public int getActiveConnectionCount() {
        return this.activeConnectionCount.intValue();
    }

    @Override
    public int getIdleConnectionCount() {
        return this.maxConnectionCount - this.getActiveConnectionCount();
    }
}

