/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.http.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class MimeParse {
    protected static ParseResults parseMimeType(CharSequence mimeType) {
        String[] types;
        String[] parts = mimeType.toString().split(";");
        ParseResults results = new ParseResults();
        results.params = new HashMap<String, String>();
        String fullType = parts[0].trim();
        if (fullType.equals("*")) {
            fullType = "*/*";
        }
        if ((types = fullType.split("/", 2)).length != 2) {
            results.type = types[0].trim();
            return results;
        }
        results.type = types[0].trim();
        results.subType = types[1].trim();
        for (int i = 1; i < parts.length; ++i) {
            String p = parts[i];
            String[] subParts = p.split("=", 2);
            if (subParts.length != 2) continue;
            results.params.put(subParts[0].trim(), subParts[1].trim());
        }
        return results;
    }

    protected static ParseResults parseMediaRange(CharSequence range) {
        ParseResults results = MimeParse.parseMimeType(range);
        String q = results.params.get("q");
        float f = MimeParse.toFloat(q, -1.0f);
        if (q == null || q.trim().isEmpty() || f < 0.0f || f > 1.0f) {
            results.params.put("q", "1");
        }
        return results;
    }

    protected static FitnessAndQuality fitnessAndQualityParsed(CharSequence mimeType, Collection<ParseResults> parsedRanges) {
        int bestFitness = -1;
        float bestFitQ = 0.0f;
        ParseResults target = MimeParse.parseMediaRange(mimeType);
        for (ParseResults range : parsedRanges) {
            boolean subTypeMatch;
            boolean typeMatch;
            boolean bl = typeMatch = target.type.equals(range.type) || range.type.equals("*") || target.type.equals("*");
            if (target.subType == null || range.subType == null) {
                subTypeMatch = Objects.equals(target.subType, range.subType);
            } else {
                boolean bl2 = subTypeMatch = target.subType.equals(range.subType) || range.subType.equals("*") || target.subType.equals("*");
            }
            if (!typeMatch || !subTypeMatch) continue;
            for (String k : target.params.keySet()) {
                int paramMatches = 0;
                if (!k.equals("q") && range.params.containsKey(k) && target.params.get(k).equals(range.params.get(k))) {
                    ++paramMatches;
                }
                int fitness = range.type.equals(target.type) ? 100 : 0;
                fitness += Objects.equals(range.subType, target.subType) ? 10 : 0;
                if ((fitness += paramMatches) <= bestFitness) continue;
                bestFitness = fitness;
                bestFitQ = MimeParse.toFloat(range.params.get("q"), 0.0f);
            }
        }
        return new FitnessAndQuality(bestFitness, bestFitQ);
    }

    public static String bestMatch(Iterable<? extends CharSequence> supported, String header) {
        ArrayList<ParseResults> parseResults = new ArrayList<ParseResults>();
        ArrayList<FitnessAndQuality> weightedMatches = new ArrayList<FitnessAndQuality>();
        for (String r : header.split(",")) {
            ParseResults parseResult = MimeParse.parseMediaRange(r);
            if (parseResult == null) continue;
            parseResults.add(parseResult);
        }
        for (CharSequence charSequence : supported) {
            FitnessAndQuality fitnessAndQuality = MimeParse.fitnessAndQualityParsed(charSequence, parseResults);
            fitnessAndQuality.mimeType = charSequence.toString();
            weightedMatches.add(fitnessAndQuality);
        }
        Collections.sort(weightedMatches);
        FitnessAndQuality lastOne = (FitnessAndQuality)weightedMatches.get(weightedMatches.size() - 1);
        return lastOne.quality != 0.0f ? lastOne.mimeType : "";
    }

    private static float toFloat(String f, float ifNullOrNotANumber) {
        try {
            return f == null ? ifNullOrNotANumber : Float.valueOf(f).floatValue();
        }
        catch (NumberFormatException e) {
            return ifNullOrNotANumber;
        }
    }

    private MimeParse() {
    }

    protected static class FitnessAndQuality
    implements Comparable<FitnessAndQuality> {
        int fitness;
        float quality;
        String mimeType;

        public FitnessAndQuality(int fitness, float quality) {
            this.fitness = fitness;
            this.quality = quality;
        }

        @Override
        public int compareTo(FitnessAndQuality o) {
            if (this.fitness == o.fitness) {
                if (this.quality == o.quality) {
                    return 0;
                }
                return this.quality < o.quality ? -1 : 1;
            }
            return this.fitness < o.fitness ? -1 : 1;
        }
    }

    protected static class ParseResults {
        String type;
        String subType;
        Map<String, String> params;

        protected ParseResults() {
        }

        public String toString() {
            StringBuilder s = new StringBuilder("('" + this.type + "', '" + this.subType + "', {");
            for (String k : this.params.keySet()) {
                s.append("'").append(k).append("':'").append(this.params.get(k)).append("',");
            }
            return s.append("})").toString();
        }
    }
}

