/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.jackson.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.reflect.TypeToken;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufOutputStream;
import java.io.OutputStream;
import ratpack.core.handling.Context;
import ratpack.core.http.internal.HttpHeaderConstants;
import ratpack.core.jackson.JsonRender;
import ratpack.core.render.Renderer;
import ratpack.core.render.RendererSupport;
import ratpack.func.Types;

public class JsonRenderer
extends RendererSupport<JsonRender> {
    public static final TypeToken<Renderer<JsonRender>> TYPE = Types.intern((TypeToken)new TypeToken<Renderer<JsonRender>>(){});
    public static final Renderer<JsonRender> INSTANCE = new JsonRenderer();

    @Override
    public void render(Context ctx, JsonRender object) throws Exception {
        Class<?> viewClass;
        ObjectWriter writer = object.getObjectWriter();
        if (writer == null) {
            writer = ctx.maybeGet(ObjectWriter.class).orElseGet(() -> ((ObjectMapper)ctx.get(ObjectMapper.class)).writer());
        }
        if ((viewClass = object.getViewClass()) != null) {
            writer = writer.withView(viewClass);
        }
        ByteBuf buffer = ((ByteBufAllocator)ctx.get(ByteBufAllocator.class)).buffer();
        ByteBufOutputStream outputStream = new ByteBufOutputStream(buffer);
        try {
            writer.writeValue((OutputStream)outputStream, object.getObject());
        }
        catch (JsonProcessingException e) {
            buffer.release();
            ctx.error(e);
            return;
        }
        ctx.getResponse().contentTypeIfNotSet(HttpHeaderConstants.JSON).send(buffer);
    }
}

