/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.render.internal;

import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.util.Iterator;
import ratpack.core.handling.Context;
import ratpack.core.render.NoSuchRendererException;
import ratpack.core.render.RenderException;
import ratpack.core.render.RenderableDecorator;
import ratpack.core.render.Renderer;
import ratpack.core.render.RendererException;
import ratpack.core.render.internal.RenderController;
import ratpack.exec.Promise;
import ratpack.func.Types;

public class DefaultRenderController
implements RenderController {
    private static final TypeToken<Renderer<?>> RENDERER_TYPE = Types.intern((TypeToken)new TypeToken<Renderer<?>>(){});
    private static final TypeToken<RenderableDecorator<?>> RENDERABLE_DECORATOR_TYPE = Types.intern((TypeToken)new TypeToken<RenderableDecorator<?>>(){});

    @Override
    public void render(Object toRender, Context context) throws Exception {
        if (toRender == null) {
            context.clientError(404);
            return;
        }
        this.doRender(toRender, context);
    }

    private <T> void doRender(T toRender, Context context) throws Exception {
        Class type = (Class)Types.cast(toRender.getClass());
        Iterator decorators = Iterables.filter((Iterable)context.getAll(RENDERABLE_DECORATOR_TYPE), d -> d.getType().isAssignableFrom(type)).iterator();
        if (decorators.hasNext()) {
            Promise promise = Promise.value(toRender);
            while (decorators.hasNext()) {
                RenderableDecorator cast = (RenderableDecorator)Types.cast(decorators.next());
                promise = promise.flatMap(r -> cast.decorate(context, r));
            }
            promise.then(r -> this.doRender(context, type, r));
        } else {
            this.doRender(context, type, toRender);
        }
    }

    private <T> void doRender(Context context, Class<T> type, T decorated) {
        Iterable renderers = context.getAll(RENDERER_TYPE);
        for (Renderer renderer : renderers) {
            if (!renderer.getType().isAssignableFrom(type)) continue;
            Renderer cast = (Renderer)Types.cast((Object)renderer);
            try {
                cast.render(context, decorated);
                return;
            }
            catch (RenderException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RendererException(renderer, decorated, e);
            }
        }
        throw new NoSuchRendererException(decorated);
    }
}

