/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.server;

import java.net.URI;
import ratpack.core.http.HttpUrlBuilder;
import ratpack.core.server.RatpackServer;
import ratpack.core.server.internal.ConstantPublicAddress;
import ratpack.core.server.internal.InferringPublicAddress;
import ratpack.core.server.internal.ServerBindPublicAddress;
import ratpack.func.Action;

public interface PublicAddress {
    public static PublicAddress of(URI uri) {
        return new ConstantPublicAddress(uri);
    }

    public static PublicAddress inferred(String defaultScheme) {
        return new InferringPublicAddress(defaultScheme);
    }

    public static PublicAddress bindAddress(RatpackServer server) {
        return new ServerBindPublicAddress(server);
    }

    default public URI get() {
        throw new UnsupportedOperationException("this implementation does not support this method, use get(Context)");
    }

    default public HttpUrlBuilder builder() {
        return HttpUrlBuilder.base(this.get());
    }

    default public URI get(Action<? super HttpUrlBuilder> action) throws Exception {
        return ((HttpUrlBuilder)action.with((Object)this.builder())).build();
    }

    default public URI get(String path) {
        return this.builder().path(path).build();
    }
}

