/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.server;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import io.netty.handler.ssl.SslContext;
import io.netty.util.Mapping;
import java.net.InetAddress;
import java.net.URI;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Optional;
import ratpack.config.ConfigData;
import ratpack.config.ConfigObject;
import ratpack.config.FileSystemBinding;
import ratpack.core.impose.Impositions;
import ratpack.core.server.DecodingErrorLevel;
import ratpack.core.server.NoBaseDirException;
import ratpack.core.server.ServerConfigBuilder;
import ratpack.core.server.internal.DefaultServerConfigBuilder;
import ratpack.core.server.internal.ServerEnvironment;
import ratpack.func.Action;
import ratpack.func.Nullable;
import ratpack.func.Types;

public interface ServerConfig
extends ConfigData {
    public static final TypeToken<ServerConfig> TYPE = Types.token(ServerConfig.class);
    public static final int DEFAULT_PORT = 5050;
    public static final int DEFAULT_MAX_CONTENT_LENGTH = 0x100000;
    public static final int DEFAULT_THREADS = Runtime.getRuntime().availableProcessors() * 2;
    public static final int DEFAULT_MAX_CHUNK_SIZE = 8192;
    public static final int DEFAULT_MAX_INITIAL_LINE_LENGTH = 4096;
    public static final int DEFAULT_MAX_HEADER_SIZE = 8192;

    public static ServerConfigBuilder embedded() {
        return ServerConfig.builder().development(true).port(0);
    }

    public static ServerConfigBuilder builder() {
        return new DefaultServerConfigBuilder(ServerEnvironment.env(), Impositions.current());
    }

    public static ServerConfig of(Action<? super ServerConfigBuilder> action) throws Exception {
        return ((ServerConfigBuilder)action.with((Object)ServerConfig.builder())).build();
    }

    public int getPort();

    public Optional<Path> getPortFile();

    @Nullable
    public InetAddress getAddress();

    public ImmutableSet<ConfigObject<?>> getRequiredConfig();

    public boolean isDevelopment();

    public int getThreads();

    public boolean isRegisterShutdownHook();

    public URI getPublicAddress();

    public Mapping<String, SslContext> getSslContext();

    public int getMaxContentLength();

    public Optional<Integer> getConnectTimeoutMillis();

    public Optional<Integer> getMaxMessagesPerRead();

    public Optional<Integer> getReceiveBufferSize();

    public Optional<Integer> getConnectQueueSize();

    public Optional<Integer> getWriteSpinCount();

    public boolean isHasBaseDir();

    public int getMaxChunkSize();

    public int getMaxInitialLineLength();

    public int getMaxHeaderSize();

    public Duration getIdleTimeout();

    public FileSystemBinding getBaseDir() throws NoBaseDirException;

    public DecodingErrorLevel getDecodingErrorLevel();
}

