/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.server.internal;

import com.google.common.net.HostAndPort;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public class HostUtil {
    public static String determineHost(InetSocketAddress socketAddress) {
        InetAddress address = socketAddress.getAddress();
        return HostUtil.determineHost(address);
    }

    public static String determineHost(HostAndPort hostAndPort) {
        try {
            InetAddress address = InetAddress.getByName(hostAndPort.getHost());
            return HostUtil.determineHost(address);
        }
        catch (UnknownHostException e) {
            return hostAndPort.getHost();
        }
    }

    private static String determineHost(InetAddress address) {
        if (address.isLoopbackAddress() || address.isAnyLocalAddress()) {
            return "localhost";
        }
        return address.getHostAddress();
    }
}

