/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.server.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBufAllocator;
import java.time.Clock;
import java.util.Optional;
import ratpack.config.ConfigObject;
import ratpack.config.FileSystemBinding;
import ratpack.core.error.ClientErrorHandler;
import ratpack.core.error.ServerErrorHandler;
import ratpack.core.error.internal.DefaultDevelopmentErrorHandler;
import ratpack.core.error.internal.DefaultProductionErrorHandler;
import ratpack.core.error.internal.ErrorHandler;
import ratpack.core.file.MimeTypes;
import ratpack.core.file.internal.ActivationBackedMimeTypes;
import ratpack.core.file.internal.FileRenderer;
import ratpack.core.form.internal.FormParser;
import ratpack.core.handling.Redirector;
import ratpack.core.handling.RequestId;
import ratpack.core.handling.internal.UuidBasedRequestIdGenerator;
import ratpack.core.health.internal.HealthCheckResultsRenderer;
import ratpack.core.http.client.HttpClient;
import ratpack.core.http.client.HttpClientSpec;
import ratpack.core.impose.Impositions;
import ratpack.core.jackson.internal.JsonParser;
import ratpack.core.jackson.internal.JsonRenderer;
import ratpack.core.render.internal.CharSequenceRenderer;
import ratpack.core.render.internal.OptionalRenderer;
import ratpack.core.render.internal.PromiseRenderer;
import ratpack.core.render.internal.PublisherRenderer;
import ratpack.core.render.internal.RenderableRenderer;
import ratpack.core.server.PublicAddress;
import ratpack.core.server.RatpackServer;
import ratpack.core.server.ServerConfig;
import ratpack.core.server.StartupFailureException;
import ratpack.core.server.Stopper;
import ratpack.core.sse.client.ServerSentEventClient;
import ratpack.exec.ExecController;
import ratpack.exec.ExecInitializer;
import ratpack.exec.ExecInterceptor;
import ratpack.exec.internal.ExecControllerInternal;
import ratpack.exec.registry.Registry;
import ratpack.exec.registry.RegistryBuilder;
import ratpack.func.Action;
import ratpack.func.Exceptions;
import ratpack.func.Function;

public abstract class ServerRegistry {
    public static Registry serverRegistry(RatpackServer ratpackServer, Impositions impositions, ExecControllerInternal execController, ServerConfig serverConfig, Function<? super Registry, ? extends Registry> userRegistryFactory) {
        Registry baseRegistry = ServerRegistry.buildBaseRegistry(ratpackServer, impositions, (ExecController)execController, serverConfig);
        Registry userRegistry = ServerRegistry.buildUserRegistry(userRegistryFactory, baseRegistry);
        execController.setInterceptors(ImmutableList.copyOf((Iterable)userRegistry.getAll(ExecInterceptor.class)));
        execController.setInitializers(ImmutableList.copyOf((Iterable)userRegistry.getAll(ExecInitializer.class)));
        return baseRegistry.join(userRegistry);
    }

    private static Registry buildUserRegistry(Function<? super Registry, ? extends Registry> userRegistryFactory, Registry baseRegistry) {
        Registry userRegistry;
        try {
            userRegistry = (Registry)userRegistryFactory.apply((Object)baseRegistry);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new StartupFailureException("Failed to build user registry", e);
        }
        return userRegistry;
    }

    public static Registry buildBaseRegistry(RatpackServer ratpackServer, Impositions impositions, ExecController execController, ServerConfig serverConfig) {
        RegistryBuilder baseRegistryBuilder;
        ErrorHandler errorHandler = serverConfig.isDevelopment() ? new DefaultDevelopmentErrorHandler() : new DefaultProductionErrorHandler();
        try {
            HttpClient httpClient = HttpClient.of((Action<? super HttpClientSpec>)((Action)s -> s.poolSize(0).byteBufAllocator(ByteBufAllocator.DEFAULT).maxContentLength(serverConfig.getMaxContentLength()).execController(execController)));
            baseRegistryBuilder = Registry.builder().add(ServerConfig.class, (Object)serverConfig).add(Impositions.class, (Object)impositions).add(ByteBufAllocator.class, (Object)ByteBufAllocator.DEFAULT).add(ExecController.class, (Object)execController).add(MimeTypes.class, (Object)ActivationBackedMimeTypes.INSTANCE).add(PublicAddress.class, (Object)Optional.ofNullable(serverConfig.getPublicAddress()).map(PublicAddress::of).orElseGet(() -> PublicAddress.bindAddress(ratpackServer))).add(Redirector.TYPE, (Object)Redirector.standard()).add(ClientErrorHandler.class, (Object)errorHandler).add(ServerErrorHandler.class, (Object)errorHandler).add(FileRenderer.TYPE, serverConfig.isDevelopment() ? FileRenderer.NON_CACHING : FileRenderer.CACHING).add(PromiseRenderer.TYPE, PromiseRenderer.INSTANCE).add(PublisherRenderer.TYPE, PublisherRenderer.INSTANCE).add(OptionalRenderer.TYPE, OptionalRenderer.INSTANCE).add(RenderableRenderer.TYPE, RenderableRenderer.INSTANCE).add(CharSequenceRenderer.TYPE, CharSequenceRenderer.INSTANCE).add(JsonRenderer.TYPE, JsonRenderer.INSTANCE).add(FormParser.TYPE, FormParser.INSTANCE).add(JsonParser.TYPE, JsonParser.INSTANCE).add(Clock.class, (Object)Clock.systemDefaultZone()).add(RatpackServer.class, (Object)ratpackServer).add(ObjectMapper.class, (Object)new ObjectMapper()).add(Stopper.class, () -> Exceptions.uncheck(() -> {
                ratpackServer.stop();
                return null;
            })).add(HttpClient.class, (Object)httpClient).add(ServerSentEventClient.class, (Object)ServerSentEventClient.of(httpClient)).add(HealthCheckResultsRenderer.TYPE, (Object)new HealthCheckResultsRenderer(ByteBufAllocator.DEFAULT)).add(RequestId.Generator.class, (Object)UuidBasedRequestIdGenerator.INSTANCE);
            ServerRegistry.addConfigObjects(serverConfig, baseRegistryBuilder);
        }
        catch (Exception e) {
            throw Exceptions.uncheck((Throwable)e);
        }
        if (serverConfig.isHasBaseDir()) {
            baseRegistryBuilder.add(FileSystemBinding.class, (Object)serverConfig.getBaseDir());
        }
        return baseRegistryBuilder.build();
    }

    private static void addConfigObjects(ServerConfig serverConfig, RegistryBuilder baseRegistryBuilder) {
        for (ConfigObject configObject : serverConfig.getRequiredConfig()) {
            ServerRegistry.addConfigObject(baseRegistryBuilder, configObject);
        }
    }

    private static <T> void addConfigObject(RegistryBuilder baseRegistryBuilder, ConfigObject<T> configObject) {
        baseRegistryBuilder.add(configObject.getTypeToken(), configObject.getObject());
    }
}

