/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec;

import com.google.common.reflect.TypeToken;
import io.netty.channel.EventLoop;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import ratpack.exec.ExecController;
import ratpack.exec.ExecInterceptor;
import ratpack.exec.ExecStarter;
import ratpack.exec.Operation;
import ratpack.exec.Promise;
import ratpack.exec.UnmanagedThreadException;
import ratpack.exec.internal.DefaultExecution;
import ratpack.exec.internal.ExecThreadBinding;
import ratpack.func.Block;
import ratpack.registry.MutableRegistry;

public interface Execution
extends MutableRegistry {
    public static Execution current() throws UnmanagedThreadException {
        return DefaultExecution.require();
    }

    public static Optional<Execution> currentOpt() {
        return Optional.ofNullable(DefaultExecution.get());
    }

    public static ExecStarter fork() throws UnmanagedThreadException {
        return ExecController.require().fork();
    }

    public static boolean isActive() {
        DefaultExecution execution = DefaultExecution.get();
        return execution != null && !execution.isComplete();
    }

    public static boolean isManagedThread() {
        return ExecThreadBinding.get() != null;
    }

    public static boolean isComputeThread() {
        return ExecThreadBinding.maybeGet().map(ExecThreadBinding::isCompute).orElse(false);
    }

    public static boolean isBlockingThread() {
        return ExecThreadBinding.maybeGet().map(threadBinding -> !threadBinding.isCompute()).orElse(false);
    }

    public ExecController getController();

    public EventLoop getEventLoop();

    public void onComplete(AutoCloseable var1);

    public boolean isComplete();

    @Override
    default public <O> Execution add(Class<O> type, O object) {
        MutableRegistry.super.add(type, object);
        return this;
    }

    @Override
    default public <O> Execution add(TypeToken<O> type, O object) {
        MutableRegistry.super.add(type, object);
        return this;
    }

    @Override
    default public Execution add(Object object) {
        MutableRegistry.super.add(object);
        return this;
    }

    @Override
    default public <O> Execution addLazy(Class<O> type, Supplier<? extends O> supplier) {
        MutableRegistry.super.addLazy(type, supplier);
        return this;
    }

    @Override
    public <O> Execution addLazy(TypeToken<O> var1, Supplier<? extends O> var2);

    public void addInterceptor(ExecInterceptor var1, Block var2) throws Exception;

    public static void sleep(Duration duration, Block onWake) {
        Execution.sleep(duration).then(onWake);
    }

    public static Operation sleep(Duration duration) {
        if (duration.isNegative()) {
            throw new IllegalArgumentException("Sleep duration must be non negative (value: " + duration + ")");
        }
        if (duration.isZero()) {
            return Operation.noop();
        }
        return Promise.async(down -> {
            try {
                Execution.current().getEventLoop().schedule(() -> down.success(null), duration.toNanos(), TimeUnit.NANOSECONDS);
            }
            catch (Throwable e) {
                down.error(e);
            }
        }).operation();
    }
}

