/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import ratpack.api.NonBlocking;
import ratpack.exec.Blocking;
import ratpack.exec.Downstream;
import ratpack.exec.ExecResult;
import ratpack.exec.ExecSpec;
import ratpack.exec.Execution;
import ratpack.exec.Operation;
import ratpack.exec.Result;
import ratpack.exec.Throttle;
import ratpack.exec.Upstream;
import ratpack.exec.internal.CachingUpstream;
import ratpack.exec.internal.DefaultExecution;
import ratpack.exec.internal.DefaultPromise;
import ratpack.exec.util.Promised;
import ratpack.exec.util.retry.RetryPolicy;
import ratpack.func.Action;
import ratpack.func.BiAction;
import ratpack.func.BiFunction;
import ratpack.func.Block;
import ratpack.func.Factory;
import ratpack.func.Function;
import ratpack.func.Pair;
import ratpack.func.Predicate;
import ratpack.util.Exceptions;

public interface Promise<T> {
    public static <T> Promise<T> async(Upstream<T> upstream) {
        return new DefaultPromise<T>(DefaultExecution.upstream(upstream));
    }

    public static <T> Promise<T> sync(Factory<T> factory) {
        return new DefaultPromise(down -> DefaultExecution.require().delimit(down::error, continuation -> {
            Object t;
            try {
                t = factory.create();
            }
            catch (Exception e) {
                continuation.resume(() -> down.error(e));
                return;
            }
            continuation.resume(() -> down.success(t));
        }));
    }

    public static <T> Promise<T> flatten(Factory<? extends Promise<T>> factory) {
        return new DefaultPromise(down -> {
            Promise promise;
            try {
                promise = (Promise)factory.create();
            }
            catch (Exception e) {
                down.error(e);
                return;
            }
            promise.connect(down);
        });
    }

    @Deprecated
    public static <T> Promise<T> wrap(Factory<? extends Promise<T>> factory) {
        try {
            return (Promise)factory.create();
        }
        catch (Exception e) {
            return Promise.error(e);
        }
    }

    public static <T> Promise<T> value(T t) {
        return new DefaultPromise(down -> DefaultExecution.require().delimit(down::error, continuation -> continuation.resume(() -> down.success(t))));
    }

    public static <T> Promise<T> ofNull() {
        return DefaultPromise.NULL;
    }

    public static <T> Promise<T> error(Throwable t) {
        return new DefaultPromise(down -> DefaultExecution.require().delimit(down::error, continuation -> continuation.resume(() -> down.error(t))));
    }

    @Deprecated
    public static <T> Promise<T> of(Upstream<T> upstream) {
        return Promise.async(upstream);
    }

    @Deprecated
    public static <T> Promise<T> ofLazy(Factory<T> factory) {
        return Promise.sync(factory);
    }

    public void then(Action<? super T> var1);

    public void connect(Downstream<? super T> var1);

    public <O> Promise<O> transform(Function<? super Upstream<? extends T>, ? extends Upstream<O>> var1);

    default public Promise<T> onError(Predicate<? super Throwable> predicate, Action<? super Throwable> errorHandler) {
        return this.transform(up -> down -> up.connect(down.onError(throwable -> {
            if (predicate.apply((Throwable)throwable)) {
                try {
                    errorHandler.execute((Throwable)throwable);
                }
                catch (Throwable e) {
                    if (e != throwable) {
                        e.addSuppressed((Throwable)throwable);
                    }
                    down.error(e);
                    return;
                }
                down.complete();
            } else {
                down.error((Throwable)throwable);
            }
        })));
    }

    default public <E extends Throwable> Promise<T> onError(Class<E> errorType, Action<? super E> errorHandler) {
        return this.onError(errorType::isInstance, (? super Throwable t) -> errorHandler.execute((Object)errorType.cast(t)));
    }

    default public Promise<T> onError(Action<? super Throwable> errorHandler) {
        return this.onError(Predicate.TRUE, errorHandler);
    }

    default public void result(final Action<? super ExecResult<T>> resultHandler) {
        this.connect(new Downstream<T>(){

            @Override
            public void success(T value) {
                try {
                    resultHandler.execute(ExecResult.of(Result.success(value)));
                }
                catch (Throwable e) {
                    DefaultPromise.throwError(e);
                }
            }

            @Override
            public void error(Throwable throwable) {
                try {
                    resultHandler.execute(ExecResult.of(Result.error(throwable)));
                }
                catch (Throwable e) {
                    DefaultPromise.throwError(e);
                }
            }

            @Override
            public void complete() {
                try {
                    resultHandler.execute(ExecResult.complete());
                }
                catch (Throwable e) {
                    DefaultPromise.throwError(e);
                }
            }
        });
    }

    default public <O> Promise<O> map(Function<? super T, ? extends O> transformer) {
        return this.transform(up -> down -> up.connect(down.onSuccess(value -> {
            try {
                Object apply = transformer.apply((Object)value);
                down.success(apply);
            }
            catch (Throwable e) {
                down.error(e);
            }
        })));
    }

    default public Promise<T> mapIf(Predicate<? super T> predicate, Function<? super T, ? extends T> transformer) {
        return this.map(Function.when(predicate, transformer));
    }

    default public <O> Promise<O> mapIf(Predicate<? super T> predicate, Function<? super T, ? extends O> onTrue, Function<? super T, ? extends O> onFalse) {
        return this.map(Function.when(predicate, onTrue, onFalse));
    }

    default public <O> Promise<O> blockingMap(Function<? super T, ? extends O> transformer) {
        return this.flatMap(t -> Blocking.get(() -> transformer.apply((Object)t)));
    }

    default public Promise<T> blockingOp(Action<? super T> action) {
        return this.flatMap(t -> Blocking.op(action.curry(t)).map(() -> t));
    }

    @Deprecated
    default public <O> Promise<O> next(Promise<O> next) {
        return this.flatMap(in -> next);
    }

    default public Promise<T> next(@NonBlocking Action<? super T> action) {
        return this.nextOp(v -> Operation.of(() -> action.execute(v)));
    }

    default public Promise<T> nextOp(Function<? super T, ? extends Operation> function) {
        return this.transform(up -> down -> up.connect(down.onSuccess(value -> ((Operation)function.apply((Object)value)).onError(down::error).then(() -> down.success(value)))));
    }

    default public Promise<T> nextOpIf(Predicate<? super T> predicate, Function<? super T, ? extends Operation> function) {
        return this.transform(up -> down -> up.connect(down.onSuccess(value -> {
            if (predicate.apply(value)) {
                ((Operation)function.apply((Object)value)).onError(down::error).then(() -> down.success(value));
            } else {
                down.success(value);
            }
        })));
    }

    default public <O> Promise<O> replace(Promise<O> next) {
        return this.flatMap(in -> next);
    }

    default public <O> Promise<Pair<O, T>> left(Promise<O> left) {
        return this.flatLeft(t -> left);
    }

    default public <O> Promise<Pair<O, T>> left(Function<? super T, ? extends O> leftFunction) {
        return this.map(right -> Pair.of(leftFunction.apply((Object)right), right));
    }

    default public <O> Promise<Pair<O, T>> flatLeft(Function<? super T, ? extends Promise<O>> leftFunction) {
        return this.flatMap(right -> ((Promise)leftFunction.apply((Object)right)).map(left -> Pair.of(left, right)));
    }

    default public <O> Promise<Pair<T, O>> right(Promise<O> right) {
        return this.flatRight(t -> right);
    }

    default public <O> Promise<Pair<T, O>> right(Function<? super T, ? extends O> rightFunction) {
        return this.map(left -> Pair.of(left, rightFunction.apply((Object)left)));
    }

    default public <O> Promise<Pair<T, O>> flatRight(Function<? super T, ? extends Promise<O>> rightFunction) {
        return this.flatMap(left -> ((Promise)rightFunction.apply((Object)left)).map(right -> Pair.of(left, right)));
    }

    default public Operation operation() {
        return this.operation(Action.noop());
    }

    default public Operation operation(@NonBlocking Action<? super T> action) {
        return Operation.of(() -> this.then(action));
    }

    default public Operation flatOp(Function<? super T, ? extends Operation> function) {
        return this.operation(t -> ((Operation)function.apply((Object)t)).then());
    }

    default public Promise<T> mapError(Function<? super Throwable, ? extends T> transformer) {
        return this.transform(up -> down -> up.connect(down.onError(throwable -> {
            try {
                Object transformed = transformer.apply((Throwable)throwable);
                down.success(transformed);
            }
            catch (Throwable t) {
                down.error(t);
            }
        })));
    }

    default public <E extends Throwable> Promise<T> mapError(Class<E> type, Function<? super E, ? extends T> function) {
        return this.transform(up -> down -> up.connect(down.onError(throwable -> {
            if (type.isInstance(throwable)) {
                Object transformed;
                try {
                    transformed = function.apply((Object)type.cast(throwable));
                }
                catch (Throwable t) {
                    down.error(t);
                    return;
                }
                down.success(transformed);
            } else {
                down.error((Throwable)throwable);
            }
        })));
    }

    default public Promise<T> mapError(Predicate<? super Throwable> predicate, Function<? super Throwable, ? extends T> function) {
        return this.transform(up -> down -> up.connect(down.onError(throwable -> {
            if (predicate.apply((Throwable)throwable)) {
                Object transformed;
                try {
                    transformed = function.apply((Throwable)throwable);
                }
                catch (Throwable t) {
                    down.error(t);
                    return;
                }
                down.success(transformed);
            } else {
                down.error((Throwable)throwable);
            }
        })));
    }

    default public Promise<T> flatMapError(Function<? super Throwable, ? extends Promise<T>> function) {
        return this.transform(up -> down -> up.connect(down.onError(throwable -> {
            Promise transformed;
            try {
                transformed = (Promise)function.apply((Throwable)throwable);
            }
            catch (Throwable t) {
                down.error(t);
                return;
            }
            transformed.connect(down);
        })));
    }

    default public <E extends Throwable> Promise<T> flatMapError(Class<E> type, Function<? super E, ? extends Promise<T>> function) {
        return this.transform(up -> down -> up.connect(down.onError(throwable -> {
            if (type.isInstance(throwable)) {
                Promise transformed;
                try {
                    transformed = (Promise)function.apply((Object)type.cast(throwable));
                }
                catch (Throwable t) {
                    down.error(t);
                    return;
                }
                transformed.connect(down);
            } else {
                down.error((Throwable)throwable);
            }
        })));
    }

    default public Promise<T> flatMapError(Predicate<? super Throwable> predicate, Function<? super Throwable, ? extends Promise<T>> function) {
        return this.transform(up -> down -> up.connect(down.onError(throwable -> {
            if (predicate.apply((Throwable)throwable)) {
                Promise transformed;
                try {
                    transformed = (Promise)function.apply((Throwable)throwable);
                }
                catch (Throwable t) {
                    down.error(t);
                    return;
                }
                transformed.connect(down);
            } else {
                down.error((Throwable)throwable);
            }
        })));
    }

    default public <O> Promise<O> apply(Function<? super Promise<T>, ? extends Promise<O>> function) {
        try {
            return function.apply(this);
        }
        catch (Throwable e) {
            return Promise.error(e);
        }
    }

    default public <O> O to(Function<? super Promise<T>, ? extends O> function) throws Exception {
        return function.apply(this);
    }

    default public <O> Promise<O> flatMap(Function<? super T, ? extends Promise<O>> transformer) {
        return this.transform(up -> down -> up.connect(down.onSuccess(value -> {
            try {
                ((Promise)transformer.apply((Object)value)).onError(down::error).then(down::success);
            }
            catch (Throwable e) {
                down.error(e);
            }
        })));
    }

    default public Promise<T> flatMapIf(Predicate<? super T> predicate, Function<? super T, ? extends Promise<T>> transformer) {
        return this.flatMapIf(predicate, transformer, Promise::value);
    }

    default public <O> Promise<O> flatMapIf(Predicate<? super T> predicate, Function<? super T, ? extends Promise<O>> onTrue, Function<? super T, ? extends Promise<O>> onFalse) {
        return this.flatMap(Function.when(predicate, onTrue, onFalse));
    }

    default public Promise<T> route(Predicate<? super T> predicate, Action<? super T> action) {
        return this.transform(up -> down -> up.connect(down.onSuccess(value -> {
            boolean apply;
            try {
                apply = predicate.apply(value);
            }
            catch (Throwable e) {
                down.error(e);
                return;
            }
            if (apply) {
                try {
                    action.execute(value);
                    down.complete();
                }
                catch (Throwable e) {
                    down.error(e);
                }
            } else {
                down.success(value);
            }
        })));
    }

    default public Promise<T> onNull(Block action) {
        return this.route(Objects::isNull, Action.ignoreArg(action));
    }

    default public Promise<T> cache() {
        return this.cacheResultIf(Predicate.TRUE);
    }

    default public Promise<T> cacheIf(Predicate<? super T> shouldCache) {
        return this.cacheResultIf(r -> r.isSuccess() && shouldCache.apply((Object)r.getValue()));
    }

    default public Promise<T> cacheResultIf(Predicate<? super ExecResult<T>> shouldCache) {
        return this.transform(up -> new CachingUpstream(up, shouldCache.function(Duration.ofSeconds(-1L), Duration.ZERO)));
    }

    default public Promise<T> cacheResultFor(Function<? super ExecResult<T>, Duration> cacheFor) {
        return this.transform(up -> new CachingUpstream(up, cacheFor));
    }

    default public Promise<T> defer(Action<? super Runnable> releaser) {
        return this.transform(up -> down -> Promise.async(innerDown -> releaser.execute(() -> innerDown.success(true))).then(v -> up.connect(down)));
    }

    default public Promise<T> defer(Duration duration) {
        return this.defer((? super Runnable r) -> Execution.sleep(duration, r::run));
    }

    default public Promise<T> onYield(Runnable onYield) {
        return this.transform(up -> down -> {
            try {
                onYield.run();
            }
            catch (Throwable e) {
                down.error(e);
                return;
            }
            up.connect(down);
        });
    }

    default public Promise<T> wiretap(final Action<? super Result<T>> listener) {
        return this.transform(up -> down -> up.connect(new Downstream<T>(){

            @Override
            public void success(T value) {
                try {
                    listener.execute(Result.success(value));
                }
                catch (Exception e) {
                    down.error(e);
                    return;
                }
                down.success(value);
            }

            @Override
            public void error(Throwable throwable) {
                try {
                    listener.execute(Result.error(throwable));
                }
                catch (Exception e) {
                    throwable.addSuppressed(e);
                }
                down.error(throwable);
            }

            @Override
            public void complete() {
                down.complete();
            }
        }));
    }

    default public Promise<T> throttled(Throttle throttle) {
        return throttle.throttle(this);
    }

    default public Promise<T> close(final AutoCloseable closeable) {
        return this.transform(up -> down -> up.connect(new Downstream<T>(){

            @Override
            public void success(T value) {
                try {
                    closeable.close();
                }
                catch (Exception e) {
                    down.error(e);
                    return;
                }
                down.success(value);
            }

            @Override
            public void error(Throwable throwable) {
                try {
                    closeable.close();
                }
                catch (Exception e) {
                    throwable.addSuppressed(e);
                }
                down.error(throwable);
            }

            @Override
            public void complete() {
                try {
                    closeable.close();
                }
                catch (Exception e) {
                    down.error(e);
                    return;
                }
                down.complete();
            }
        }));
    }

    default public Promise<T> close(final Operation closer) {
        return this.transform(up -> down -> up.connect(new Downstream<T>(){

            @Override
            public void success(final T value) {
                closer.promise().connect(new Downstream<Void>(){

                    @Override
                    public void success(Void v) {
                        down.success(value);
                    }

                    @Override
                    public void error(Throwable throwable) {
                        down.error(throwable);
                    }

                    @Override
                    public void complete() {
                        down.success(value);
                    }
                });
            }

            @Override
            public void error(final Throwable throwable) {
                closer.promise().connect(new Downstream<Void>(){

                    @Override
                    public void success(Void v) {
                        down.error(throwable);
                    }

                    @Override
                    public void error(Throwable innerThrowable) {
                        innerThrowable.addSuppressed(throwable);
                        down.error(innerThrowable);
                    }

                    @Override
                    public void complete() {
                        down.error(throwable);
                    }
                });
            }

            @Override
            public void complete() {
                closer.promise().connect(new Downstream<Void>(){

                    @Override
                    public void success(Void v) {
                        down.complete();
                    }

                    @Override
                    public void error(Throwable innerThrowable) {
                        down.error(innerThrowable);
                    }

                    @Override
                    public void complete() {
                        down.complete();
                    }
                });
            }
        }));
    }

    default public Promise<T> time(Action<? super Duration> action) {
        return this.timeResult((r, d) -> action.execute((Duration)d));
    }

    default public Promise<T> timeResult(BiAction<? super ExecResult<T>, ? super Duration> action) {
        return this.around(System::nanoTime, (start, result) -> {
            Duration duration = Duration.ofNanos(Math.max(0L, System.nanoTime() - start));
            action.execute((Object)result, duration);
            return result;
        });
    }

    default public Promise<Pair<ExecResult<T>, Duration>> timeResult() {
        return this.around(System::nanoTime, (start, result) -> {
            Duration duration = Duration.ofNanos(Math.max(0L, System.nanoTime() - start));
            return ExecResult.of(Result.success(Pair.of(result, duration)));
        });
    }

    default public <B, A> Promise<A> around(Factory<? extends B> before, final BiFunction<? super B, ? super ExecResult<T>, ? extends ExecResult<A>> after) {
        return this.transform(up -> down -> {
            Object start;
            try {
                start = before.create();
            }
            catch (Throwable e) {
                down.error(e);
                return;
            }
            up.connect(new Downstream<T>(){

                private void onResult(ExecResult<T> originalResult) {
                    ExecResult newResult;
                    try {
                        newResult = (ExecResult)after.apply(start, originalResult);
                    }
                    catch (Throwable t) {
                        if (originalResult.isError() && originalResult.getThrowable() != t) {
                            t.addSuppressed(originalResult.getThrowable());
                        }
                        down.error(t);
                        return;
                    }
                    down.accept(newResult);
                }

                @Override
                public void success(T value) {
                    this.onResult(ExecResult.of(Result.success(value)));
                }

                @Override
                public void error(Throwable throwable) {
                    this.onResult(ExecResult.of(Result.error(throwable)));
                }

                @Override
                public void complete() {
                    this.onResult(ExecResult.complete());
                }
            });
        });
    }

    default public Promise<T> fork(Action<? super ExecSpec> execSpec) throws Exception {
        Promised promised = new Promised();
        execSpec.with(Execution.fork()).start(e -> this.connect(promised));
        return promised.promise();
    }

    default public Promise<T> fork() {
        return (Promise)Exceptions.uncheck(() -> this.fork(Action.noop()));
    }

    @Deprecated
    default public Promise<T> retry(int maxAttempts, Duration delay, @NonBlocking BiAction<? super Integer, ? super Throwable> onError) {
        Promise<Duration> delayPromise = Promise.value(delay);
        return this.retry(maxAttempts, (? super Integer i, ? super Throwable error) -> Operation.of(() -> onError.execute((Integer)i, (Throwable)error)).flatMap(delayPromise));
    }

    @Deprecated
    default public Promise<T> retry(int maxAttempts, BiFunction<? super Integer, ? super Throwable, Promise<Duration>> onError) {
        return this.transform(up -> down -> DefaultPromise.retryAttempt(1, maxAttempts, up, down, onError));
    }

    default public Promise<T> retry(RetryPolicy retryPolicy, BiAction<? super Integer, ? super Throwable> onError) {
        return this.transform(up -> down -> DefaultPromise.retry(retryPolicy, up, down, onError));
    }

    default public CompletableFuture<T> toCompletableFuture() {
        CompletableFuture future = new CompletableFuture();
        this.onError(future::completeExceptionally).then(future::complete);
        return future;
    }

    public static <T> Promise<T> toPromise(CompletableFuture<T> future) {
        return Promise.async(downstream -> downstream.accept(future));
    }
}

