/*
 * Decompiled with CFR 0.152.
 */
package ratpack.registry.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import ratpack.func.Function;
import ratpack.registry.Registry;
import ratpack.registry.internal.RegistryEntry;
import ratpack.registry.internal.TypeCaching;
import ratpack.util.Types;

public class MultiEntryRegistry
implements Registry {
    private final Iterable<? extends RegistryEntry<?>> entries;

    public MultiEntryRegistry(Iterable<? extends RegistryEntry<?>> entries) {
        this.entries = entries;
    }

    public String toString() {
        return "Registry{" + this.entries + '}';
    }

    @Override
    public <O> Optional<O> maybeGet(TypeToken<O> type) {
        ConcurrentMap<TypeToken<?>, Boolean> cache = TypeCaching.cache(type);
        for (RegistryEntry<?> entry : this.entries) {
            if (!TypeCaching.isAssignableFrom(cache, type, entry.getType())) continue;
            Object cast = entry.get();
            return Optional.ofNullable(cast);
        }
        return Optional.empty();
    }

    @Override
    public <O> Iterable<? extends O> getAll(TypeToken<O> type) {
        ImmutableList.Builder builder = null;
        ConcurrentMap<TypeToken<?>, Boolean> cache = TypeCaching.cache(type);
        for (RegistryEntry<?> entry : this.entries) {
            if (!TypeCaching.isAssignableFrom(cache, type, entry.getType())) continue;
            if (builder == null) {
                builder = ImmutableList.builder();
            }
            RegistryEntry<?> cast = entry;
            builder.add(cast);
        }
        if (builder == null) {
            return Collections.emptyList();
        }
        return Iterables.transform((Iterable)builder.build(), RegistryEntry::get);
    }

    @Override
    public <T, O> Optional<O> first(TypeToken<T> type, Function<? super T, ? extends O> function) throws Exception {
        ConcurrentMap<TypeToken<?>, Boolean> cache = TypeCaching.cache(type);
        for (RegistryEntry<?> entry : this.entries) {
            RegistryEntry cast;
            O result;
            if (!TypeCaching.isAssignableFrom(cache, type, entry.getType()) || (result = function.apply((cast = (RegistryEntry)Types.cast(entry)).get())) == null) continue;
            return Optional.of(result);
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiEntryRegistry that = (MultiEntryRegistry)o;
        return this.entries.equals(that.entries);
    }

    public int hashCode() {
        return this.entries.hashCode();
    }
}

