/*
 * Decompiled with CFR 0.152.
 */
package ratpack.gradle.continuous.run;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import ratpack.gradle.continuous.run.RatpackAdapter;
import ratpack.gradle.continuous.run.RatpackServerProxy;
import ratpack.gradle.continuous.run.RatpackSpec;

public class DefaultRatpackAdapter
implements RatpackAdapter,
Serializable {
    private static final Logger LOGGER = Logging.getLogger(RatpackAdapter.class);
    private final RatpackSpec spec;
    private boolean started;
    private ClassLoader baseLoader;
    private ClassLoader appLoader;
    private RatpackServerProxy server;

    public DefaultRatpackAdapter(RatpackSpec spec) {
        this.spec = spec;
    }

    @Override
    public void start() {
        if (this.started) {
            throw new IllegalStateException("already started");
        }
        this.started = true;
        this.baseLoader = new URLClassLoader(this.spec.getClasspath(), DefaultRatpackAdapter.maybeGetPlatformClassLoader());
        this.reload();
    }

    private static ClassLoader maybeGetPlatformClassLoader() {
        try {
            Method method = ClassLoader.class.getDeclaredMethod("getPlatformClassLoader", new Class[0]);
            Object result = method.invoke(null, new Object[0]);
            return (ClassLoader)result;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    @Override
    public void reload() {
        this.stop();
        if (this.appLoader != null && this.appLoader instanceof Closeable) {
            try {
                ((Closeable)((Object)this.appLoader)).close();
            }
            catch (IOException e) {
                LOGGER.warn("failed to close old classloader", (Throwable)e);
            }
        }
        this.appLoader = new URLClassLoader(this.spec.getChangingClasspath(), this.baseLoader);
        this.inContext(new Runnable(){

            @Override
            public void run() {
                DefaultRatpackAdapter.this.server = RatpackServerProxy.capture(DefaultRatpackAdapter.this.appLoader, DefaultRatpackAdapter.this.spec.getMainClass(), DefaultRatpackAdapter.this.spec.getArgs());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inContext(Runnable runnable) {
        Thread currentThread = Thread.currentThread();
        ClassLoader threadClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(this.appLoader);
        String threadName = currentThread.getName();
        currentThread.setName("main");
        try {
            runnable.run();
        }
        finally {
            currentThread.setContextClassLoader(threadClassLoader);
            currentThread.setName(threadName);
        }
    }

    @Override
    public void buildError(Throwable throwable) {
    }

    @Override
    public boolean isRunning() {
        return this.server != null && this.server.isRunning();
    }

    @Override
    public void stop() {
        if (this.server != null) {
            this.inContext(new Runnable(){

                @Override
                public void run() {
                    DefaultRatpackAdapter.this.server.stop();
                }
            });
        }
    }
}

