/*
 * Decompiled with CFR 0.152.
 */
package ratpack.hikari;

import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.pool.HikariPool;
import javax.sql.DataSource;
import ratpack.guice.ConfigurableModule;
import ratpack.hikari.HikariService;

public class HikariModule
extends ConfigurableModule<HikariConfig> {
    protected void configure() {
    }

    @Provides
    @Singleton
    public HikariDataSource hikariDataSource(HikariConfig config) {
        return new HikariDataSource(config);
    }

    @Provides
    @Singleton
    public HikariPool hikariPool(HikariDataSource hikariDataSource) {
        return (HikariPool)hikariDataSource.getHikariPoolMXBean();
    }

    @Provides
    @Singleton
    public HikariService hikariService(HikariDataSource hikariDataSource) {
        return new HikariService(hikariDataSource);
    }

    @Provides
    @Singleton
    public DataSource dataSource(HikariService service) {
        return this.getDataSource(service);
    }

    protected DataSource getDataSource(HikariService service) {
        return service.getDataSource();
    }
}

