/*
 * Decompiled with CFR 0.152.
 */
package ratpack.hystrix.internal;

import com.netflix.hystrix.strategy.concurrency.HystrixRequestVariable;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestVariableLifecycle;
import ratpack.exec.Execution;
import ratpack.hystrix.internal.HystrixCommandCache;

class HystrixRegistryBackedRequestVariable<T>
implements HystrixRequestVariable<T> {
    private HystrixRequestVariableLifecycle<T> rv;

    public HystrixRegistryBackedRequestVariable(HystrixRequestVariableLifecycle<T> rv) {
        this.rv = rv;
    }

    public T get() {
        Execution execution = this.getExecution();
        HystrixCommandCache commandCache = execution.maybeGet(HystrixCommandCache.class).orElseGet(() -> {
            HystrixCommandCache cache = new HystrixCommandCache();
            execution.add((Object)cache);
            return cache;
        });
        Object command = commandCache.get(this);
        if (command == null) {
            command = this.rv.initialValue();
            commandCache.putIfAbsent(this, command);
        }
        return (T)command;
    }

    private Execution getExecution() {
        return Execution.current();
    }

    public T initialValue() {
        return (T)this.rv.initialValue();
    }

    public void shutdown(T value) {
        this.rv.shutdown(value);
    }
}

