/*
 * Decompiled with CFR 0.152.
 */
package ratpack.hystrix.internal;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.netflix.hystrix.HystrixCollapserKey;
import com.netflix.hystrix.HystrixCollapserMetrics;
import com.netflix.hystrix.util.HystrixRollingNumberEvent;
import java.io.StringWriter;
import java.io.Writer;
import ratpack.func.Function;

public class HystrixCollapserMetricsJsonMapper
implements Function<HystrixCollapserMetrics, String> {
    private final JsonFactory jsonFactory = new JsonFactory();

    public String apply(HystrixCollapserMetrics collapserMetrics) throws Exception {
        HystrixCollapserKey key = collapserMetrics.getCollapserKey();
        StringWriter jsonString = new StringWriter();
        JsonGenerator json = this.jsonFactory.createGenerator((Writer)jsonString);
        json.writeStartObject();
        json.writeStringField("type", "HystrixCollapser");
        json.writeStringField("name", key.name());
        json.writeNumberField("currentTime", System.currentTimeMillis());
        json.writeNumberField("rollingCountRequestsBatched", collapserMetrics.getRollingCount(HystrixRollingNumberEvent.COLLAPSER_REQUEST_BATCHED));
        json.writeNumberField("rollingCountBatches", collapserMetrics.getRollingCount(HystrixRollingNumberEvent.COLLAPSER_BATCH));
        json.writeNumberField("rollingCountResponsesFromCache", collapserMetrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
        json.writeNumberField("batchSize_mean", collapserMetrics.getBatchSizeMean());
        json.writeObjectFieldStart("batchSize");
        json.writeNumberField("25", collapserMetrics.getBatchSizePercentile(25.0));
        json.writeNumberField("50", collapserMetrics.getBatchSizePercentile(50.0));
        json.writeNumberField("75", collapserMetrics.getBatchSizePercentile(75.0));
        json.writeNumberField("90", collapserMetrics.getBatchSizePercentile(90.0));
        json.writeNumberField("95", collapserMetrics.getBatchSizePercentile(95.0));
        json.writeNumberField("99", collapserMetrics.getBatchSizePercentile(99.0));
        json.writeNumberField("99.5", collapserMetrics.getBatchSizePercentile(99.5));
        json.writeNumberField("100", collapserMetrics.getBatchSizePercentile(100.0));
        json.writeEndObject();
        json.writeBooleanField("propertyValue_requestCacheEnabled", ((Boolean)collapserMetrics.getProperties().requestCacheEnabled().get()).booleanValue());
        json.writeNumberField("propertyValue_maxRequestsInBatch", ((Integer)collapserMetrics.getProperties().maxRequestsInBatch().get()).intValue());
        json.writeNumberField("propertyValue_timerDelayInMilliseconds", ((Integer)collapserMetrics.getProperties().timerDelayInMilliseconds().get()).intValue());
        json.writeNumberField("reportingHosts", 1);
        json.writeEndObject();
        json.close();
        return jsonString.getBuffer().toString();
    }
}

