/*
 * Decompiled with CFR 0.152.
 */
package ratpack.rx.internal;

import com.google.common.collect.MapMaker;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import ratpack.exec.ExecController;
import ratpack.rx.internal.ExecControllerBackedScheduler;
import rx.Scheduler;
import rx.schedulers.Schedulers;

public class MultiExecControllerBackedScheduler
extends Scheduler {
    private final ConcurrentMap<ExecController, Scheduler> map = new MapMaker().weakKeys().weakValues().makeMap();
    private final AtomicReference<Scheduler> fallback = new AtomicReference();

    private Scheduler getDelegateScheduler() {
        return ExecController.current().map(c -> this.map.computeIfAbsent((ExecController)c, ExecControllerBackedScheduler::new)).orElseGet(() -> {
            if (this.fallback.get() == null) {
                int nThreads = Runtime.getRuntime().availableProcessors();
                ExecutorService executor = Executors.newFixedThreadPool(nThreads);
                Scheduler scheduler = Schedulers.from((Executor)executor);
                this.fallback.compareAndSet(null, scheduler);
            }
            return this.fallback.get();
        });
    }

    public Scheduler.Worker createWorker() {
        return this.getDelegateScheduler().createWorker();
    }

    public long now() {
        return this.getDelegateScheduler().now();
    }
}

