/*
 * Decompiled with CFR 0.152.
 */
package ratpack.rx.internal;

import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import ratpack.exec.ExecController;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action0;
import rx.schedulers.Schedulers;

public class ExecControllerBackedScheduler
extends Scheduler {
    private final ExecController execController;
    private final Scheduler delegateScheduler;

    public ExecControllerBackedScheduler(ExecController execController) {
        this.execController = execController;
        this.delegateScheduler = Schedulers.from((Executor)execController.getEventLoopGroup());
    }

    public long now() {
        return this.delegateScheduler.now();
    }

    public Scheduler.Worker createWorker() {
        return new Scheduler.Worker(){
            private final Scheduler.Worker delegateWorker;
            {
                this.delegateWorker = ExecControllerBackedScheduler.this.delegateScheduler.createWorker();
            }

            public Subscription schedule(Action0 action) {
                return this.delegateWorker.schedule((Action0)new ExecutionWrappedAction(action));
            }

            public Subscription schedule(Action0 action, long delayTime, TimeUnit unit) {
                return this.delegateWorker.schedule((Action0)new ExecutionWrappedAction(action), delayTime, unit);
            }

            public void unsubscribe() {
                this.delegateWorker.unsubscribe();
            }

            public boolean isUnsubscribed() {
                return this.delegateWorker.isUnsubscribed();
            }

            public long now() {
                return this.delegateWorker.now();
            }

            class ExecutionWrappedAction
            implements Action0 {
                private final Action0 delegate;

                ExecutionWrappedAction(Action0 delegate) {
                    this.delegate = delegate;
                }

                public void call() {
                    ExecControllerBackedScheduler.this.execController.fork().start(execution -> this.delegate.call());
                }
            }
        };
    }
}

