/*
 * Decompiled with CFR 0.152.
 */
package ratpack.rx2.internal;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.OnErrorNotImplementedException;
import io.reactivex.exceptions.UndeliverableException;
import ratpack.exec.Promise;
import ratpack.func.Action;

public class ExecutionBackedObserver<T>
implements Observer<T> {
    private final Observer<? super T> observer;

    public ExecutionBackedObserver(Observer<? super T> observer) {
        this.observer = observer;
    }

    public void onComplete() {
        try {
            this.observer.onComplete();
        }
        catch (OnErrorNotImplementedException e) {
            Promise.error((Throwable)e.getCause()).then(Action.noop());
        }
        catch (Exception e) {
            Promise.error((Throwable)new UndeliverableException((Throwable)e)).then(Action.noop());
        }
    }

    public void onError(Throwable e) {
        try {
            this.observer.onError(e);
        }
        catch (OnErrorNotImplementedException e2) {
            Promise.error((Throwable)e2.getCause()).then(Action.noop());
        }
        catch (Exception e2) {
            Promise.error((Throwable)new CompositeException(new Throwable[]{e, e2})).then(Action.noop());
        }
    }

    public void onSubscribe(Disposable d) {
        try {
            this.observer.onSubscribe(d);
        }
        catch (OnErrorNotImplementedException e) {
            Promise.error((Throwable)e.getCause()).then(Action.noop());
        }
        catch (Exception e) {
            Promise.error((Throwable)new UndeliverableException((Throwable)e)).then(Action.noop());
        }
    }

    public void onNext(T t) {
        try {
            this.observer.onNext(t);
        }
        catch (OnErrorNotImplementedException e) {
            Promise.error((Throwable)e.getCause()).then(Action.noop());
        }
        catch (Exception e) {
            Promise.error((Throwable)new UndeliverableException((Throwable)e)).then(Action.noop());
        }
    }
}

