/*
 * Decompiled with CFR 0.152.
 */
package ratpack.rx2.internal;

import io.reactivex.FlowableSubscriber;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.OnErrorNotImplementedException;
import io.reactivex.exceptions.UndeliverableException;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import ratpack.exec.Promise;
import ratpack.func.Action;

public class ExecutionBackedSubscriber<T>
implements FlowableSubscriber<T> {
    private final Subscriber<? super T> subscriber;

    public ExecutionBackedSubscriber(Subscriber<T> subscriber) {
        this.subscriber = subscriber;
    }

    public void onComplete() {
        try {
            this.subscriber.onComplete();
        }
        catch (OnErrorNotImplementedException e) {
            Promise.error((Throwable)e.getCause()).then(Action.noop());
        }
        catch (Exception e) {
            Promise.error((Throwable)new UndeliverableException((Throwable)e)).then(Action.noop());
        }
    }

    public void onError(Throwable e) {
        try {
            this.subscriber.onError(e);
        }
        catch (OnErrorNotImplementedException e2) {
            Promise.error((Throwable)e2.getCause()).then(Action.noop());
        }
        catch (Exception e2) {
            Promise.error((Throwable)new CompositeException(new Throwable[]{e, e2})).then(Action.noop());
        }
    }

    public void onSubscribe(Subscription s) {
        try {
            this.subscriber.onSubscribe(s);
        }
        catch (OnErrorNotImplementedException e) {
            Promise.error((Throwable)e.getCause()).then(Action.noop());
        }
        catch (Exception e) {
            Promise.error((Throwable)new UndeliverableException((Throwable)e)).then(Action.noop());
        }
    }

    public void onNext(T t) {
        try {
            this.subscriber.onNext(t);
        }
        catch (OnErrorNotImplementedException e) {
            Promise.error((Throwable)e.getCause()).then(Action.noop());
        }
        catch (Exception e) {
            Promise.error((Throwable)new UndeliverableException((Throwable)e)).then(Action.noop());
        }
    }
}

