/*
 * Decompiled with CFR 0.152.
 */
package ratpack.rx2.internal;

import io.reactivex.Scheduler;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import ratpack.exec.ExecController;

public abstract class ExecutorBackedScheduler
extends Scheduler {
    protected final ExecController execController;
    protected final Scheduler delegateScheduler;

    protected ExecutorBackedScheduler(ExecController execController) {
        this.execController = execController;
        this.delegateScheduler = Schedulers.from((Executor)this.getExecutor());
    }

    abstract ExecutorService getExecutor();

    public long now(@NonNull TimeUnit unit) {
        return this.delegateScheduler.now(unit);
    }

    public Scheduler.Worker createWorker() {
        return new Scheduler.Worker(){
            private final Scheduler.Worker delegateWorker;
            {
                this.delegateWorker = ExecutorBackedScheduler.this.delegateScheduler.createWorker();
            }

            public Disposable schedule(@NonNull Runnable run) {
                return this.delegateWorker.schedule((Runnable)new ExecutionWrappedAction(run));
            }

            public Disposable schedule(@NonNull Runnable run, long delayTime, TimeUnit unit) {
                return this.delegateWorker.schedule((Runnable)new ExecutionWrappedAction(run), delayTime, unit);
            }

            public void dispose() {
                this.delegateWorker.dispose();
            }

            public boolean isDisposed() {
                return this.delegateWorker.isDisposed();
            }

            public long now(@NonNull TimeUnit unit) {
                return this.delegateWorker.now(unit);
            }

            class ExecutionWrappedAction
            implements Runnable {
                private final Runnable delegate;

                ExecutionWrappedAction(Runnable delegate) {
                    this.delegate = delegate;
                }

                @Override
                public void run() {
                    ExecutorBackedScheduler.this.execController.fork().start(execution -> this.delegate.run());
                }
            }
        };
    }
}

