/*
 * Decompiled with CFR 0.152.
 */
package ratpack.rx2.internal;

import com.google.common.collect.MapMaker;
import io.reactivex.Scheduler;
import io.reactivex.annotations.NonNull;
import io.reactivex.schedulers.Schedulers;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import ratpack.exec.ExecController;
import ratpack.rx2.internal.ExecutorBackedScheduler;

public abstract class MultiExecutorBackedScheduler
extends Scheduler {
    private final ConcurrentMap<ExecController, Scheduler> map = new MapMaker().weakKeys().weakValues().makeMap();
    private final AtomicReference<Scheduler> fallback = new AtomicReference();

    public abstract ExecutorBackedScheduler getExecutorBackedScheduler(ExecController var1);

    private Scheduler getDelegateScheduler() {
        return ExecController.current().map(c -> this.map.computeIfAbsent((ExecController)c, this::getExecutorBackedScheduler)).orElseGet(() -> {
            if (this.fallback.get() == null) {
                int nThreads = Runtime.getRuntime().availableProcessors();
                ExecutorService executor = Executors.newFixedThreadPool(nThreads);
                Scheduler scheduler = Schedulers.from((Executor)executor);
                this.fallback.compareAndSet(null, scheduler);
            }
            return this.fallback.get();
        });
    }

    public Scheduler.Worker createWorker() {
        return this.getDelegateScheduler().createWorker();
    }

    public long now(@NonNull TimeUnit unit) {
        return this.getDelegateScheduler().now(unit);
    }
}

