/*
 * Decompiled with CFR 0.152.
 */
package ratpack.spring.internal;

import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import ratpack.registry.RegistryBacking;
import ratpack.util.Types;

public class SpringRegistryBacking
implements RegistryBacking {
    private final ListableBeanFactory beanFactory;

    public SpringRegistryBacking(ListableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public <T> Iterable<Supplier<? extends T>> provide(TypeToken<T> type) {
        return FluentIterable.from((Iterable)ImmutableList.copyOf((Object[])BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, (Class)type.getRawType())).reverse()).transform(beanName -> () -> Types.cast((Object)this.beanFactory.getBean(beanName)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpringRegistryBacking that = (SpringRegistryBacking)o;
        return this.beanFactory.equals(that.beanFactory);
    }

    public int hashCode() {
        return this.beanFactory.hashCode();
    }
}

