/*
 * Decompiled with CFR 0.152.
 */
package ratpack.spring.config.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.stereotype.Component;
import ratpack.func.Action;
import ratpack.handling.Chain;
import ratpack.handling.Handler;
import ratpack.handling.Handlers;
import ratpack.server.ServerConfig;
import ratpack.spring.config.RatpackServerCustomizer;

@Component
public class ChainConfigurers
implements Action<Chain> {
    @Autowired(required=false)
    private List<Action<Chain>> delegates = Collections.emptyList();
    @Autowired(required=false)
    private List<Handler> handlers = Collections.emptyList();
    @Autowired(required=false)
    private List<RatpackServerCustomizer> customizers = Collections.emptyList();

    public void execute(Chain chain) throws Exception {
        ArrayList<Action<Chain>> delegates = new ArrayList<Action<Chain>>(this.delegates);
        for (RatpackServerCustomizer ratpackServerCustomizer : this.customizers) {
            delegates.addAll(ratpackServerCustomizer.getHandlers());
        }
        if (this.handlers.size() == 1 || delegates.isEmpty()) {
            delegates.add(this.singleHandlerAction());
        }
        delegates.add(this.staticResourcesAction(chain.getServerConfig()));
        AnnotationAwareOrderComparator.sort(delegates);
        for (Action action : delegates) {
            if (action instanceof ChainConfigurers) continue;
            action.execute((Object)chain);
        }
    }

    private Action<Chain> staticResourcesAction(ServerConfig config) {
        return chain -> chain.all(Handlers.files((ServerConfig)config, f -> f.dir("static").indexFiles(new String[]{"index.html"}))).all(Handlers.files((ServerConfig)config, f -> f.dir("public").indexFiles(new String[]{"index.html"})));
    }

    private Action<Chain> singleHandlerAction() {
        return chain -> {
            if (this.handlers.size() == 1) {
                chain.get(this.handlers.get(0));
            }
        };
    }
}

