/*
 * Decompiled with CFR 0.152.
 */
package ratpack.test;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import ratpack.registry.Registry;
import ratpack.server.RatpackServer;
import ratpack.server.internal.ServerCapturer;
import ratpack.test.ServerBackedApplicationUnderTest;

public class MainClassApplicationUnderTest
extends ServerBackedApplicationUnderTest {
    private final Class<?> mainClass;

    public MainClassApplicationUnderTest(Class<?> mainClass) {
        this.mainClass = mainClass;
    }

    protected Registry createOverrides(Registry serverRegistry) throws Exception {
        return Registry.empty();
    }

    @Override
    protected RatpackServer createServer() throws Exception {
        RatpackServer ratpackServer = ServerCapturer.capture((ServerCapturer.Overrides)new ServerCapturer.Overrides().port(0).development(true).registry(this::createOverrides), () -> {
            Method method;
            try {
                method = this.mainClass.getDeclaredMethod("main", String[].class);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Class" + this.mainClass.getName() + " does not have a main(String...) class");
            }
            if (!Modifier.isStatic(method.getModifiers())) {
                throw new IllegalStateException(this.mainClass.getName() + ".main() must be static");
            }
            try {
                method.invoke(null, new Object[]{new String[0]});
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new IllegalStateException("Could not invoke " + this.mainClass.getName() + ".main()", e);
            }
        });
        if (ratpackServer == null) {
            throw new IllegalStateException(this.mainClass.getName() + ".main() did not start a Ratpack server");
        }
        return ratpackServer;
    }
}

