/*
 * Decompiled with CFR 0.152.
 */
package ratpack.test;

import java.net.URI;
import java.net.URISyntaxException;
import ratpack.server.RatpackServer;
import ratpack.test.CloseableApplicationUnderTest;
import ratpack.util.Exceptions;

public abstract class ServerBackedApplicationUnderTest
implements CloseableApplicationUnderTest {
    private RatpackServer server;

    protected abstract RatpackServer createServer() throws Exception;

    @Override
    public URI getAddress() {
        URI address;
        if (this.server == null) {
            try {
                this.server = this.createServer();
                this.server.start();
            }
            catch (Exception e) {
                throw Exceptions.uncheck((Throwable)e);
            }
        }
        try {
            address = new URI(this.server.getScheme() + "://" + this.server.getBindHost() + ":" + this.server.getBindPort() + "/");
        }
        catch (URISyntaxException e) {
            throw Exceptions.uncheck((Throwable)e);
        }
        return address;
    }

    public void stop() {
        if (this.server != null) {
            try {
                this.server.stop();
                this.server = null;
            }
            catch (Exception e) {
                throw Exceptions.uncheck((Throwable)e);
            }
        }
    }

    @Override
    public void close() {
        this.stop();
    }
}

