/*
 * Decompiled with CFR 0.152.
 */
package ratpack.test.exec.internal;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import ratpack.exec.ExecController;
import ratpack.exec.ExecResult;
import ratpack.exec.Execution;
import ratpack.exec.Promise;
import ratpack.exec.Result;
import ratpack.exec.internal.CompleteExecResult;
import ratpack.exec.internal.ResultBackedExecResult;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.registry.Registry;
import ratpack.registry.RegistrySpec;
import ratpack.test.exec.ExecHarness;
import ratpack.util.Exceptions;

public class DefaultExecHarness
implements ExecHarness {
    private final ExecController controller;

    public DefaultExecHarness(ExecController controller) {
        this.controller = controller;
    }

    @Override
    public ExecController getController() {
        return this.controller;
    }

    @Override
    public <T> ExecResult<T> yield(Action<? super RegistrySpec> registry, Function<? super Execution, ? extends Promise<T>> func) throws Exception {
        AtomicReference reference = new AtomicReference();
        CountDownLatch latch = new CountDownLatch(1);
        this.controller.fork().register(registry).onError(throwable -> reference.set(new ResultBackedExecResult(Result.error((Throwable)throwable), (Registry)Execution.current()))).onComplete(exec -> latch.countDown()).start(execution -> {
            reference.set(new CompleteExecResult((Registry)execution));
            Promise promise = (Promise)func.apply(execution);
            if (promise == null) {
                reference.set(null);
            } else {
                promise.then(t -> reference.set(new ResultBackedExecResult(Result.success((Object)t), (Registry)execution)));
            }
        });
        latch.await();
        return (ExecResult)reference.get();
    }

    @Override
    public void run(Action<? super RegistrySpec> registry, Action<? super Execution> action) throws Exception {
        AtomicReference thrown = new AtomicReference();
        CountDownLatch latch = new CountDownLatch(1);
        this.controller.fork().onError(thrown::set).register(registry).onComplete(e -> latch.countDown()).start(arg_0 -> action.execute(arg_0));
        latch.await();
        Throwable throwable = (Throwable)thrown.get();
        if (throwable != null) {
            throw Exceptions.toException((Throwable)throwable);
        }
    }

    @Override
    public void close() {
        this.controller.close();
    }
}

