/*
 * Decompiled with CFR 0.152.
 */
package ratpack.test.handling.internal;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.CharsetUtil;
import java.nio.file.Path;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Subscriber;
import org.slf4j.LoggerFactory;
import ratpack.exec.ExecController;
import ratpack.file.internal.ResponseTransmitter;
import ratpack.func.Action;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.handling.RequestOutcome;
import ratpack.handling.internal.ChainHandler;
import ratpack.handling.internal.DefaultContext;
import ratpack.handling.internal.DefaultRequestOutcome;
import ratpack.http.Headers;
import ratpack.http.MutableHeaders;
import ratpack.http.Request;
import ratpack.http.SentResponse;
import ratpack.http.Status;
import ratpack.http.internal.DefaultRequest;
import ratpack.http.internal.DefaultResponse;
import ratpack.http.internal.DefaultSentResponse;
import ratpack.http.internal.DefaultStatus;
import ratpack.http.internal.DelegatingHeaders;
import ratpack.registry.Registry;
import ratpack.render.internal.RenderController;
import ratpack.server.Stopper;
import ratpack.test.handling.HandlerExceptionNotThrownException;
import ratpack.test.handling.HandlerTimeoutException;
import ratpack.test.handling.HandlingResult;
import ratpack.test.handling.UnexpectedHandlerException;
import ratpack.util.Exceptions;

public class DefaultHandlingResult
implements HandlingResult {
    private DefaultContext.RequestConstants requestConstants;
    private Headers headers;
    private byte[] body = new byte[0];
    private Status status;
    private boolean calledNext;
    private boolean sentResponse;
    private Path sentFile;
    private Object rendered;
    private ResultsHolder results;

    public DefaultHandlingResult(final DefaultRequest request, ResultsHolder results, MutableHeaders responseHeaders, Registry registry, int timeout, Handler handler) throws Exception {
        this.headers = new DelegatingHeaders((Headers)responseHeaders);
        this.results = results;
        final CountDownLatch latch = results.getLatch();
        Handler next = context -> {
            this.calledNext = true;
            results.getLatch().countDown();
        };
        RenderController renderController = (object, context) -> {
            this.rendered = object;
            latch.countDown();
        };
        Stopper stopper = () -> {
            throw new UnsupportedOperationException("stopping not supported while unit testing");
        };
        ResponseTransmitter responseTransmitter = new ResponseTransmitter(){
            private List<Action<? super RequestOutcome>> outcomeListeners = Lists.newArrayList();

            public void transmit(HttpResponseStatus status, ByteBuf byteBuf) {
                DefaultHandlingResult.this.sentResponse = true;
                DefaultHandlingResult.access$102(DefaultHandlingResult.this, new byte[byteBuf.readableBytes()]);
                byteBuf.readBytes(DefaultHandlingResult.this.body);
                byteBuf.release();
                this.fire((RequestOutcome)new DefaultRequestOutcome((Request)request, (SentResponse)new DefaultSentResponse(DefaultHandlingResult.this.headers, (Status)new DefaultStatus(status)), Instant.now()));
                latch.countDown();
            }

            public void transmit(HttpResponseStatus status, Path file) {
                DefaultHandlingResult.this.sentFile = file;
                this.fire((RequestOutcome)new DefaultRequestOutcome((Request)request, (SentResponse)new DefaultSentResponse(DefaultHandlingResult.this.headers, DefaultHandlingResult.this.status), Instant.now()));
                latch.countDown();
            }

            public Subscriber<ByteBuf> transmitter(HttpResponseStatus status) {
                throw new UnsupportedOperationException("streaming not supported while unit testing");
            }

            private void fire(RequestOutcome requestOutcome) {
                for (Action<? super RequestOutcome> outcomeListener : this.outcomeListeners) {
                    try {
                        outcomeListener.execute((Object)requestOutcome);
                    }
                    catch (Exception e) {
                        LoggerFactory.getLogger(DefaultHandlingResult.class).warn("request outcome listener " + outcomeListener + " threw exception", (Throwable)e);
                    }
                }
            }

            public void addOutcomeListener(Action<? super RequestOutcome> action) {
                this.outcomeListeners.add(action);
            }

            public void forceCloseConnection() {
            }
        };
        ExecController execController = (ExecController)registry.get(ExecController.class);
        Registry effectiveRegistry = Registry.single(Stopper.class, (Object)stopper).join(registry);
        DefaultContext.ApplicationConstants applicationConstants = new DefaultContext.ApplicationConstants(effectiveRegistry, renderController, execController, next);
        this.requestConstants = new DefaultContext.RequestConstants(applicationConstants, request, null, responseTransmitter, null);
        DefaultResponse response = new DefaultResponse(responseHeaders, (ByteBufAllocator)registry.get(ByteBufAllocator.class), responseTransmitter);
        this.requestConstants.response = response;
        DefaultContext.start((EventLoop)execController.getEventLoopGroup().next(), (DefaultContext.RequestConstants)this.requestConstants, (Registry)effectiveRegistry, (Handler[])ChainHandler.unpack((Handler)handler), (Action)Action.noop());
        try {
            if (!latch.await(timeout, TimeUnit.SECONDS)) {
                throw new HandlerTimeoutException(this, timeout);
            }
        }
        catch (InterruptedException e) {
            throw Exceptions.uncheck((Throwable)e);
        }
        finally {
            this.status = response.getStatus();
        }
    }

    @Override
    public byte[] getBodyBytes() {
        Throwable throwable = this.results.getThrowable();
        if (throwable != null) {
            throw new UnexpectedHandlerException(throwable);
        }
        if (this.sentResponse) {
            return this.body;
        }
        return null;
    }

    @Override
    public String getBodyText() {
        Throwable throwable = this.results.getThrowable();
        if (throwable != null) {
            throw new UnexpectedHandlerException(throwable);
        }
        if (this.sentResponse) {
            return new String(this.body, CharsetUtil.UTF_8);
        }
        return null;
    }

    @Override
    public Integer getClientError() {
        return this.results.getClientError();
    }

    private Context getContext() {
        return this.requestConstants.context;
    }

    @Override
    public <T extends Throwable> T exception(Class<T> clazz) {
        Throwable throwable = this.results.getThrowable();
        if (throwable == null) {
            throw new HandlerExceptionNotThrownException();
        }
        if (clazz.isAssignableFrom(throwable.getClass())) {
            return (T)((Throwable)clazz.cast(throwable));
        }
        throw new UnexpectedHandlerException(throwable);
    }

    @Override
    public Headers getHeaders() {
        return this.headers;
    }

    @Override
    public Registry getRegistry() {
        return this.getContext();
    }

    @Override
    public Registry getRequestRegistry() {
        return this.getContext().getRequest();
    }

    @Override
    public Path getSentFile() {
        return this.sentFile;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public boolean isCalledNext() {
        Throwable throwable = this.results.getThrowable();
        if (throwable != null) {
            throw new UnexpectedHandlerException(throwable);
        }
        return this.calledNext;
    }

    @Override
    public boolean isSentResponse() {
        return this.sentResponse;
    }

    @Override
    public <T> T rendered(Class<T> type) {
        Throwable throwable = this.results.getThrowable();
        if (throwable != null) {
            throw new UnexpectedHandlerException(throwable);
        }
        if (this.rendered == null) {
            return null;
        }
        if (type.isAssignableFrom(this.rendered.getClass())) {
            return type.cast(this.rendered);
        }
        throw new AssertionError((Object)String.format("Wrong type of object rendered. Was expecting %s but got %s", type, this.rendered.getClass()));
    }

    static /* synthetic */ byte[] access$102(DefaultHandlingResult x0, byte[] x1) {
        x0.body = x1;
        return x1;
    }

    public static class ResultsHolder {
        private Integer clientError;
        private Throwable throwable;
        private final CountDownLatch latch = new CountDownLatch(1);

        public Integer getClientError() {
            return this.clientError;
        }

        public void setClientError(Integer clientError) {
            this.clientError = clientError;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public void setThrowable(Throwable throwable) {
            this.throwable = throwable;
        }

        public CountDownLatch getLatch() {
            return this.latch;
        }
    }
}

