/*
 * Decompiled with CFR 0.152.
 */
package ratpack.test.http.internal;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.net.HostAndPort;
import io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.codec.http.cookie.Cookie;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.http.HttpUrlBuilder;
import ratpack.http.client.ReceivedResponse;
import ratpack.http.client.RequestSpec;
import ratpack.http.client.internal.DelegatingRequestSpec;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.test.ApplicationUnderTest;
import ratpack.test.http.TestHttpClient;
import ratpack.test.internal.BlockingHttpClient;
import ratpack.util.Exceptions;

public class DefaultTestHttpClient
implements TestHttpClient {
    private final ApplicationUnderTest applicationUnderTest;
    private final BlockingHttpClient client = new BlockingHttpClient();
    private final Action<? super RequestSpec> defaultRequestConfig;
    private final Map<String, List<Cookie>> cookies = Maps.newLinkedHashMap();
    private Action<? super RequestSpec> request = Action.noop();
    private Action<? super ImmutableMultimap.Builder<String, Object>> params = Action.noop();
    private ReceivedResponse response;

    public DefaultTestHttpClient(ApplicationUnderTest applicationUnderTest, Action<? super RequestSpec> defaultRequestConfig) {
        this.applicationUnderTest = applicationUnderTest;
        this.defaultRequestConfig = defaultRequestConfig;
    }

    @Override
    public ApplicationUnderTest getApplicationUnderTest() {
        return this.applicationUnderTest;
    }

    @Override
    public TestHttpClient requestSpec(Action<? super RequestSpec> requestAction) {
        this.request = requestAction;
        return this;
    }

    @Override
    public TestHttpClient params(Action<? super ImmutableMultimap.Builder<String, Object>> params) {
        this.params = params;
        return this;
    }

    @Override
    public void resetRequest() {
        this.request = Action.noop();
        this.cookies.clear();
    }

    @Override
    public ReceivedResponse getResponse() {
        return this.response;
    }

    @Override
    public ReceivedResponse head() {
        return this.head("");
    }

    @Override
    public ReceivedResponse head(String path) {
        return this.sendRequest("HEAD", path);
    }

    @Override
    public ReceivedResponse options() {
        return this.options("");
    }

    @Override
    public ReceivedResponse options(String path) {
        return this.sendRequest("OPTIONS", path);
    }

    @Override
    public String optionsText() {
        return this.optionsText("");
    }

    @Override
    public String optionsText(String path) {
        return this.options(path).getBody().getText();
    }

    @Override
    public ReceivedResponse get() {
        return this.get("");
    }

    @Override
    public ReceivedResponse get(String path) {
        return this.sendRequest("GET", path);
    }

    @Override
    public String getText() {
        return this.getText("");
    }

    @Override
    public String getText(String path) {
        return this.get(path).getBody().getText();
    }

    @Override
    public ReceivedResponse post() {
        return this.post("");
    }

    @Override
    public ReceivedResponse post(String path) {
        return this.sendRequest("POST", path);
    }

    @Override
    public String postText() {
        return this.postText("");
    }

    @Override
    public String postText(String path) {
        this.post(path);
        return this.response.getBody().getText();
    }

    @Override
    public ReceivedResponse put() {
        return this.put("");
    }

    @Override
    public ReceivedResponse put(String path) {
        return this.sendRequest("PUT", path);
    }

    @Override
    public String putText() {
        return this.putText("");
    }

    @Override
    public String putText(String path) {
        return this.put(path).getBody().getText();
    }

    @Override
    public ReceivedResponse patch() {
        return this.patch("");
    }

    @Override
    public ReceivedResponse patch(String path) {
        return this.sendRequest("PATCH", path);
    }

    @Override
    public String patchText() {
        return this.patchText("");
    }

    @Override
    public String patchText(String path) {
        return this.patch(path).getBody().getText();
    }

    @Override
    public ReceivedResponse delete() {
        return this.delete("");
    }

    @Override
    public ReceivedResponse delete(String path) {
        return this.sendRequest("DELETE", path);
    }

    @Override
    public String deleteText() {
        return this.deleteText("");
    }

    @Override
    public String deleteText(String path) {
        return this.delete(path).getBody().getText();
    }

    private ReceivedResponse sendRequest(String method, String path) {
        try {
            URI uri = this.builder(path).params(this.params).build();
            this.response = this.client.request(uri, Duration.ofMinutes(60L), (Action<? super RequestSpec>)((Action)requestSpec -> {
                CookieHandlingRequestSpec decorated = new CookieHandlingRequestSpec((RequestSpec)requestSpec);
                this.defaultRequestConfig.execute((Object)decorated);
                this.request.execute((Object)decorated);
                requestSpec.method(method);
                int port = uri.getPort() > 0 ? uri.getPort() : 80;
                requestSpec.getHeaders().add(HttpHeaderConstants.HOST, (Object)HostAndPort.fromParts((String)uri.getHost(), (int)port).toString());
            }));
        }
        catch (Throwable throwable) {
            throw Exceptions.uncheck((Throwable)throwable);
        }
        this.extractCookies(this.response);
        return this.response;
    }

    private void applyCookies(RequestSpec requestSpec) {
        List<Cookie> requestCookies = this.getCookies(requestSpec.getUrl().getPath());
        String encodedCookie = requestCookies.isEmpty() ? "" : ClientCookieEncoder.STRICT.encode(requestCookies);
        requestSpec.getHeaders().add(HttpHeaderConstants.COOKIE, (Object)encodedCookie);
    }

    private void extractCookies(ReceivedResponse response) {
        List cookieHeaders = response.getHeaders().getAll("Set-Cookie");
        for (String cookieHeader : cookieHeaders) {
            Cookie decodedCookie = ClientCookieDecoder.STRICT.decode(cookieHeader);
            if (decodedCookie == null) continue;
            if (decodedCookie.value() == null || decodedCookie.value().isEmpty()) {
                this.cookies.forEach((key, list) -> {
                    ListIterator iter = list.listIterator();
                    while (iter.hasNext()) {
                        if (!((Cookie)iter.next()).name().equals(decodedCookie.name())) continue;
                        iter.remove();
                    }
                });
                continue;
            }
            String cookiePath = decodedCookie.path();
            cookiePath = cookiePath != null && !"".equals(cookiePath) ? cookiePath : "/";
            LinkedList pathCookies = this.cookies.get(cookiePath);
            if (pathCookies == null) {
                pathCookies = Lists.newLinkedList();
                this.cookies.put(cookiePath, pathCookies);
            }
            if (pathCookies.contains(decodedCookie)) {
                pathCookies.remove(decodedCookie);
            }
            pathCookies.add(decodedCookie);
        }
    }

    private HttpUrlBuilder builder(String path) {
        try {
            URI basePath = new URI(path);
            if (basePath.isAbsolute()) {
                return HttpUrlBuilder.base((URI)basePath);
            }
            path = path.startsWith("/") ? path.substring(1) : path;
            return HttpUrlBuilder.base((URI)new URI(this.applicationUnderTest.getAddress().toString() + path));
        }
        catch (URISyntaxException e) {
            throw Exceptions.uncheck((Throwable)e);
        }
    }

    @Override
    public List<Cookie> getCookies(String path) {
        LinkedList clonedList = Lists.newLinkedList();
        if (this.cookies == null) {
            return clonedList;
        }
        if (path == null || "".equals(path) || "/".equals(path)) {
            List<Cookie> list = this.cookies.get("/");
            if (list != null) {
                clonedList.addAll(list);
            }
        } else {
            this.cookies.forEach((key, list2) -> {
                if ("/".equals(key)) {
                    clonedList.addAll(list2);
                } else if (path.startsWith((String)key)) {
                    clonedList.addAll(list2);
                }
            });
        }
        return clonedList;
    }

    private class CookieHandlingRequestSpec
    extends DelegatingRequestSpec {
        public CookieHandlingRequestSpec(RequestSpec delegate) {
            super(delegate);
            this.onRedirect((Function<? super ReceivedResponse, Action<? super RequestSpec>>)Function.constant((Object)Action.noop()));
            DefaultTestHttpClient.this.applyCookies((RequestSpec)this);
        }

        public RequestSpec onRedirect(Function<? super ReceivedResponse, Action<? super RequestSpec>> function) {
            return super.onRedirect(resp -> {
                DefaultTestHttpClient.this.extractCookies(resp);
                Action userFunc = (Action)function.apply((Object)DefaultTestHttpClient.this.response);
                if (userFunc == null) {
                    return null;
                }
                return spec -> {
                    CookieHandlingRequestSpec decorated = new CookieHandlingRequestSpec((RequestSpec)spec);
                    userFunc.execute((Object)decorated);
                };
            });
        }
    }
}

