/*
 * Decompiled with CFR 0.152.
 */
package ratpack.test.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.net.URI;
import java.time.Duration;
import java.time.temporal.TemporalUnit;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import ratpack.exec.Execution;
import ratpack.exec.Result;
import ratpack.exec.internal.DefaultExecController;
import ratpack.func.Action;
import ratpack.http.TypedData;
import ratpack.http.client.HttpClient;
import ratpack.http.client.ReceivedResponse;
import ratpack.http.client.RequestSpec;
import ratpack.http.client.internal.DefaultReceivedResponse;
import ratpack.http.internal.ByteBufBackedTypedData;
import ratpack.util.Exceptions;

public class BlockingHttpClient {
    public ReceivedResponse request(URI uri, Duration duration, Action<? super RequestSpec> action) throws Throwable {
        try (DefaultExecController execController = new DefaultExecController(2);){
            RequestAction requestAction = new RequestAction(uri, action);
            execController.fork().onError(throwable -> requestAction.setResult((Result<ReceivedResponse>)Result.error((Throwable)throwable))).start(requestAction::execute);
            try {
                if (!requestAction.latch.await(duration.toNanos(), TimeUnit.NANOSECONDS)) {
                    TemporalUnit unit = duration.getUnits().get(0);
                    throw new IllegalStateException("Request to " + uri + " took more than " + duration.get(unit) + " " + unit.toString() + " to complete");
                }
            }
            catch (InterruptedException e) {
                throw Exceptions.uncheck((Throwable)e);
            }
            ReceivedResponse receivedResponse = (ReceivedResponse)requestAction.result.getValueOrThrow();
            return receivedResponse;
        }
    }

    private static class RequestAction
    implements Action<Execution> {
        private final URI uri;
        private final Action<? super RequestSpec> action;
        private final CountDownLatch latch = new CountDownLatch(1);
        private Result<ReceivedResponse> result;

        private RequestAction(URI uri, Action<? super RequestSpec> action) {
            this.uri = uri;
            this.action = action;
        }

        private void setResult(Result<ReceivedResponse> result) {
            this.result = result;
            this.latch.countDown();
        }

        public void execute(Execution execution) throws Exception {
            HttpClient.httpClient((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (int)Integer.MAX_VALUE).request(this.uri, this.action.prepend(s -> s.readTimeout(Duration.ofHours(1L)))).then(response -> {
                TypedData responseBody = response.getBody();
                ByteBuf responseBodyBuffer = responseBody.getBuffer();
                responseBodyBuffer = Unpooled.unreleasableBuffer((ByteBuf)responseBodyBuffer.retain());
                DefaultReceivedResponse copiedResponse = new DefaultReceivedResponse(response.getStatus(), response.getHeaders(), new ByteBufBackedTypedData(responseBodyBuffer, responseBody.getContentType()));
                this.setResult((Result<ReceivedResponse>)Result.success((Object)copiedResponse));
            });
        }
    }
}

