/*
 * Decompiled with CFR 0.152.
 */
package ratpack.test.embed.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import ratpack.test.embed.EphemeralBaseDir;

public class PathEphemeralBaseDir
implements EphemeralBaseDir {
    private final Path baseDir;
    private final Path toDelete;

    public PathEphemeralBaseDir(File baseDir) {
        this(baseDir.toPath());
    }

    public PathEphemeralBaseDir(Path baseDir) {
        this(baseDir, baseDir);
    }

    public PathEphemeralBaseDir(Path baseDir, Path toDelete) {
        this.baseDir = baseDir;
        this.toDelete = toDelete;
    }

    @Override
    public void close() throws IOException {
        FileSystem fileSystem = this.baseDir.getFileSystem();
        if (!fileSystem.equals(FileSystems.getDefault())) {
            fileSystem.close();
        }
        System.gc();
        if (Files.exists(this.toDelete, new LinkOption[0])) {
            Files.walkFileTree(this.toDelete, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    @Override
    public Path getRoot() {
        return this.baseDir;
    }
}

